/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.core.lang.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;

public interface TimeGauge
extends Gauge {
    public static <T> Builder<T> builder(String name, T obj, TimeUnit fUnits, ToDoubleFunction<T> f) {
        return new Builder(name, obj, fUnits, f);
    }

    public TimeUnit baseTimeUnit();

    default public double value(TimeUnit unit) {
        return TimeUtils.convert(this.value(), this.baseTimeUnit(), unit);
    }

    public static class Builder<T> {
        private final String name;
        private final T obj;
        private final TimeUnit fUnits;
        private final ToDoubleFunction<T> f;
        private final List<Tag> tags = new ArrayList<Tag>();
        @Nullable
        private String description;

        private Builder(String name, T obj, TimeUnit fUnits, ToDoubleFunction<T> f) {
            this.name = name;
            this.obj = obj;
            this.fUnits = fUnits;
            this.f = f;
        }

        public Builder<T> tags(String ... tags) {
            return this.tags(Tags.of(tags));
        }

        public Builder<T> tags(Iterable<Tag> tags) {
            tags.forEach(this.tags::add);
            return this;
        }

        public Builder<T> tag(String key, String value) {
            this.tags.add(Tag.of(key, value));
            return this;
        }

        public Builder<T> description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public TimeGauge register(MeterRegistry registry) {
            return registry.more().timeGauge(new Meter.Id(this.name, this.tags, null, this.description, Meter.Type.Gauge), this.obj, this.fUnits, this.f);
        }
    }
}

