/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.search;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.search.MeterNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RequiredSearch {
    private final MeterRegistry registry;
    private final String name;
    private final List<Tag> tags = new ArrayList<Tag>();

    public RequiredSearch(MeterRegistry registry, String name) {
        this.registry = registry;
        this.name = name;
    }

    public RequiredSearch tags(Iterable<Tag> tags) {
        tags.forEach(this.tags::add);
        return this;
    }

    public RequiredSearch tags(String ... tags) {
        return this.tags(Tags.of(tags));
    }

    public Timer timer() {
        return this.findOne(Timer.class);
    }

    public Counter counter() {
        return this.findOne(Counter.class);
    }

    public Gauge gauge() {
        return this.findOne(Gauge.class);
    }

    public FunctionCounter functionCounter() {
        return this.findOne(FunctionCounter.class);
    }

    public TimeGauge timeGauge() {
        return this.findOne(TimeGauge.class);
    }

    public FunctionTimer functionTimer() {
        return this.findOne(FunctionTimer.class);
    }

    public DistributionSummary summary() {
        return this.findOne(DistributionSummary.class);
    }

    public LongTaskTimer longTaskTimer() {
        return this.findOne(LongTaskTimer.class);
    }

    public Meter meter() {
        return this.findOne(Meter.class);
    }

    private <M extends Meter> M findOne(Class<M> clazz) {
        Optional<Meter> meter = this.meters().stream().filter(clazz::isInstance).findAny().map(clazz::cast);
        if (meter.isPresent()) {
            return (M)meter.get();
        }
        throw new MeterNotFoundException(this.name, this.tags, clazz);
    }

    public Collection<Meter> meters() {
        Stream<Meter> meterStream = this.registry.getMeters().stream().filter(m -> m.getId().getName().equals(this.name));
        if (!this.tags.isEmpty()) {
            meterStream = meterStream.filter(m -> {
                ArrayList idTags = new ArrayList();
                m.getId().getTags().forEach(idTags::add);
                return idTags.containsAll(this.tags);
            });
        }
        return meterStream.collect(Collectors.toList());
    }
}

