/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.HistogramSnapshot;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.lang.Nullable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public interface DistributionSummary
extends Meter {
    public static Builder builder(String name) {
        return new Builder(name);
    }

    public void record(double var1);

    public long count();

    public double totalAmount();

    default public double mean() {
        return this.count() == 0L ? 0.0 : this.totalAmount() / (double)this.count();
    }

    public double max();

    public double percentile(double var1);

    public double histogramCountAtValue(long var1);

    public HistogramSnapshot takeSnapshot(boolean var1);

    @Override
    default public Iterable<Measurement> measure() {
        return Arrays.asList(new Measurement(() -> this.count(), Statistic.COUNT), new Measurement(this::totalAmount, Statistic.TOTAL));
    }

    public static class Builder {
        private final String name;
        private final List<Tag> tags = new ArrayList<Tag>();
        private HistogramConfig.Builder histogramConfigBuilder = HistogramConfig.builder();
        @Nullable
        private String description;
        @Nullable
        private String baseUnit;

        private Builder(String name) {
            this.name = name;
        }

        public Builder tags(String ... tags) {
            return this.tags(Tags.of(tags));
        }

        public Builder tags(Iterable<Tag> tags) {
            tags.forEach(this.tags::add);
            return this;
        }

        public Builder tag(String key, String value) {
            this.tags.add(Tag.of(key, value));
            return this;
        }

        public Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public Builder baseUnit(@Nullable String unit) {
            this.baseUnit = unit;
            return this;
        }

        public Builder publishPercentiles(double ... percentiles) {
            this.histogramConfigBuilder.percentiles(percentiles);
            return this;
        }

        public Builder publishPercentileHistogram() {
            return this.publishPercentileHistogram(true);
        }

        public Builder publishPercentileHistogram(@Nullable Boolean enabled) {
            this.histogramConfigBuilder.percentilesHistogram(enabled);
            return this;
        }

        public Builder sla(long ... sla) {
            this.histogramConfigBuilder.sla(sla);
            return this;
        }

        public Builder minimumExpectedValue(@Nullable Long min) {
            this.histogramConfigBuilder.minimumExpectedValue(min);
            return this;
        }

        public Builder maximumExpectedValue(@Nullable Long max) {
            this.histogramConfigBuilder.maximumExpectedValue(max);
            return this;
        }

        public Builder histogramExpiry(@Nullable Duration expiry) {
            this.histogramConfigBuilder.histogramExpiry(expiry);
            return this;
        }

        public Builder histogramBufferLength(@Nullable Integer bufferLength) {
            this.histogramConfigBuilder.histogramBufferLength(bufferLength);
            return this;
        }

        public DistributionSummary register(MeterRegistry registry) {
            return registry.summary(new Meter.Id(this.name, this.tags, this.baseUnit, this.description, Meter.Type.DISTRIBUTION_SUMMARY), this.histogramConfigBuilder.build());
        }
    }
}

