/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.HistogramSnapshot;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.histogram.pause.PauseDetector;
import io.micrometer.core.lang.Nullable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public interface Timer
extends Meter {
    public static Sample start(MeterRegistry registry) {
        return new Sample(registry.config().clock());
    }

    public static Sample start(Clock clock) {
        return new Sample(clock);
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static Builder builder(Timed timed, String defaultName) {
        if (timed.longTask() && timed.value().isEmpty()) {
            throw new IllegalArgumentException("Long tasks instrumented with @Timed require the value attribute to be non-empty");
        }
        return new Builder(timed.value().isEmpty() ? defaultName : timed.value()).tags(timed.extraTags()).description(timed.description().isEmpty() ? null : timed.description()).publishPercentileHistogram(timed.histogram()).publishPercentiles(timed.percentiles().length > 0 ? timed.percentiles() : null);
    }

    public void record(long var1, TimeUnit var3);

    default public void record(Duration duration) {
        this.record(duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    public <T> T record(Supplier<T> var1);

    public <T> T recordCallable(Callable<T> var1) throws Exception;

    public void record(Runnable var1);

    default public Runnable wrap(Runnable f) {
        return () -> this.record(f);
    }

    default public <T> Callable<T> wrap(Callable<T> f) {
        return () -> this.recordCallable(f);
    }

    public long count();

    public double totalTime(TimeUnit var1);

    default public double mean(TimeUnit unit) {
        return this.count() == 0L ? 0.0 : this.totalTime(unit) / (double)this.count();
    }

    public double max(TimeUnit var1);

    public double percentile(double var1, TimeUnit var3);

    public double histogramCountAtValue(long var1);

    public HistogramSnapshot takeSnapshot(boolean var1);

    @Override
    default public Iterable<Measurement> measure() {
        return Arrays.asList(new Measurement(() -> this.count(), Statistic.COUNT), new Measurement(() -> this.totalTime(this.baseTimeUnit()), Statistic.TOTAL_TIME), new Measurement(() -> this.max(this.baseTimeUnit()), Statistic.MAX));
    }

    public TimeUnit baseTimeUnit();

    @Override
    default public Meter.Type type() {
        return Meter.Type.TIMER;
    }

    public static class Builder {
        private final String name;
        private final List<Tag> tags = new ArrayList<Tag>();
        private final HistogramConfig.Builder histogramConfigBuilder;
        @Nullable
        private String description;
        @Nullable
        private PauseDetector pauseDetector;

        private Builder(String name) {
            this.name = name;
            this.histogramConfigBuilder = new HistogramConfig.Builder();
            this.minimumExpectedValue(Duration.ofMillis(1L));
            this.maximumExpectedValue(Duration.ofSeconds(30L));
        }

        public Builder tags(String ... tags) {
            return this.tags(Tags.of(tags));
        }

        public Builder tags(Iterable<Tag> tags) {
            tags.forEach(this.tags::add);
            return this;
        }

        public Builder tag(String key, String value) {
            this.tags.add(Tag.of(key, value));
            return this;
        }

        public Builder publishPercentiles(double ... percentiles) {
            this.histogramConfigBuilder.percentiles(percentiles);
            return this;
        }

        public Builder publishPercentileHistogram() {
            return this.publishPercentileHistogram(true);
        }

        public Builder publishPercentileHistogram(@Nullable Boolean enabled) {
            this.histogramConfigBuilder.percentilesHistogram(enabled);
            return this;
        }

        public Builder sla(Duration ... sla) {
            if (sla != null) {
                long[] slaNano = new long[sla.length];
                for (int i = 0; i < slaNano.length; ++i) {
                    slaNano[i] = sla[i].toNanos();
                }
                this.histogramConfigBuilder.sla(slaNano);
            }
            return this;
        }

        public Builder minimumExpectedValue(@Nullable Duration min) {
            if (min != null) {
                this.histogramConfigBuilder.minimumExpectedValue(min.toNanos());
            }
            return this;
        }

        public Builder maximumExpectedValue(@Nullable Duration max) {
            if (max != null) {
                this.histogramConfigBuilder.maximumExpectedValue(max.toNanos());
            }
            return this;
        }

        public Builder histogramExpiry(@Nullable Duration expiry) {
            this.histogramConfigBuilder.histogramExpiry(expiry);
            return this;
        }

        public Builder histogramBufferLength(@Nullable Integer bufferLength) {
            this.histogramConfigBuilder.histogramBufferLength(bufferLength);
            return this;
        }

        public Builder pauseDetector(@Nullable PauseDetector pauseDetector) {
            this.pauseDetector = pauseDetector;
            return this;
        }

        public Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public Timer register(MeterRegistry registry) {
            return registry.timer(new Meter.Id(this.name, this.tags, null, this.description, Meter.Type.TIMER), this.histogramConfigBuilder.build(), this.pauseDetector == null ? registry.config().pauseDetector() : this.pauseDetector);
        }
    }

    public static class Sample {
        private final long startTime;
        private final Clock clock;

        Sample(Clock clock) {
            this.clock = clock;
            this.startTime = clock.monotonicTime();
        }

        public long stop(Timer timer) {
            long durationNs = this.clock.monotonicTime() - this.startTime;
            timer.record(durationNs, TimeUnit.NANOSECONDS);
            return durationNs;
        }
    }
}

