/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.system;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import io.micrometer.core.lang.Nullable;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Objects;

@NonNullApi
@NonNullFields
public class ProcessorMetrics
implements MeterBinder {
    private final Iterable<Tag> tags;
    @Nullable
    private OperatingSystemMXBean operatingSystemBean;
    @Nullable
    private Method systemCpuUsage;
    @Nullable
    private Method processCpuUsage;

    public ProcessorMetrics() {
        this(Collections.emptyList());
    }

    public ProcessorMetrics(Iterable<Tag> tags) {
        this.tags = tags;
        this.operatingSystemBean = ManagementFactory.getOperatingSystemMXBean();
        this.systemCpuUsage = this.detectMethod(this.operatingSystemBean, "getSystemCpuLoad");
        this.processCpuUsage = this.detectMethod(this.operatingSystemBean, "getProcessCpuLoad");
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        Runtime runtime = Runtime.getRuntime();
        Gauge.builder("system.cpu.count", runtime, Runtime::availableProcessors).tags(this.tags).description("The number of processors available to the Java virtual machine").register(registry);
        if (this.operatingSystemBean != null && this.operatingSystemBean.getSystemLoadAverage() >= 0.0) {
            Gauge.builder("system.load.average.1m", this.operatingSystemBean, OperatingSystemMXBean::getSystemLoadAverage).tags(this.tags).description("The sum of the number of runnable entities queued to available processors and the number of runnable entities running on the available processors averaged over a period of time").register(registry);
        }
        if (this.systemCpuUsage != null) {
            Gauge.builder("system.cpu.usage", this.operatingSystemBean, x -> this.invoke((OperatingSystemMXBean)x, this.systemCpuUsage)).tags(this.tags).description("The \"recent cpu usage\" for the whole system").register(registry);
        }
        if (this.processCpuUsage != null) {
            Gauge.builder("process.cpu.usage", this.operatingSystemBean, x -> this.invoke((OperatingSystemMXBean)x, this.processCpuUsage)).tags(this.tags).description("The \"recent cpu usage\" for the Java Virtual Machine process").register(registry);
        }
    }

    private double invoke(OperatingSystemMXBean osBean, @Nullable Method method) {
        try {
            return method != null ? (Double)method.invoke((Object)osBean, new Object[0]) : Double.NaN;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return Double.NaN;
        }
    }

    @Nullable
    private Method detectMethod(@Nullable OperatingSystemMXBean osBean, String name) {
        Objects.requireNonNull(name);
        if (osBean == null) {
            return null;
        }
        try {
            Method method = osBean.getClass().getMethod(name, new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (Throwable ignored) {
            return null;
        }
    }
}

