/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.search;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import java.util.List;
import java.util.stream.Collectors;

public class MeterNotFoundException
extends RuntimeException {
    public MeterNotFoundException(String meterName, List<Tag> tags, Class<? extends Meter> meterType) {
        super("Unable to locate a meter named '" + meterName + "'" + MeterNotFoundException.tagDetail(tags) + " of type " + meterType.getCanonicalName());
    }

    private static String tagDetail(List<Tag> tags) {
        String tagDetail = "";
        if (!tags.isEmpty()) {
            tagDetail = " with Tags:[" + tags.stream().map(t -> t.getKey() + ":" + t.getValue()).collect(Collectors.joining(",")) + "]";
        }
        return tagDetail;
    }
}

