/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.util;

import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;

@Incubating(since="1.0.0-rc.6")
public class TimeDecayingMax {
    private static final AtomicIntegerFieldUpdater<TimeDecayingMax> rotatingUpdater = AtomicIntegerFieldUpdater.newUpdater(TimeDecayingMax.class, "rotating");
    private final Clock clock;
    private final long durationBetweenRotatesMillis;
    private AtomicLong[] ringBuffer;
    private int currentBucket;
    private volatile long lastRotateTimestampMillis;
    private volatile int rotating = 0;

    public TimeDecayingMax(Clock clock, HistogramConfig config) {
        this(clock, config.getHistogramExpiry().toMillis(), config.getHistogramBufferLength());
    }

    public TimeDecayingMax(Clock clock, long rotateFrequencyMillis, int bufferLength) {
        this.clock = clock;
        this.durationBetweenRotatesMillis = rotateFrequencyMillis;
        this.lastRotateTimestampMillis = clock.wallTime();
        this.currentBucket = 0;
        this.ringBuffer = new AtomicLong[bufferLength];
        for (int i = 0; i < bufferLength; ++i) {
            this.ringBuffer[i] = new AtomicLong();
        }
    }

    public void record(double sample, TimeUnit timeUnit) {
        this.rotate();
        long sampleNanos = (long)TimeUtils.convert(sample, timeUnit, TimeUnit.NANOSECONDS);
        for (AtomicLong max : this.ringBuffer) {
            this.updateMax(max, sampleNanos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double poll(TimeUnit timeUnit) {
        this.rotate();
        TimeDecayingMax timeDecayingMax = this;
        synchronized (timeDecayingMax) {
            return TimeUtils.nanosToUnit(this.ringBuffer[this.currentBucket].get(), timeUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double poll() {
        this.rotate();
        TimeDecayingMax timeDecayingMax = this;
        synchronized (timeDecayingMax) {
            return Double.longBitsToDouble(this.ringBuffer[this.currentBucket].get());
        }
    }

    public void record(double sample) {
        this.rotate();
        long sampleLong = Double.doubleToLongBits(sample);
        for (AtomicLong max : this.ringBuffer) {
            this.updateMax(max, sampleLong);
        }
    }

    private void updateMax(AtomicLong max, long sample) {
        long curMax;
        while ((curMax = max.get()) < sample && !max.compareAndSet(curMax, sample)) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rotate() {
        long timeSinceLastRotateMillis = this.clock.wallTime() - this.lastRotateTimestampMillis;
        if (timeSinceLastRotateMillis < this.durationBetweenRotatesMillis) {
            return;
        }
        if (!rotatingUpdater.compareAndSet(this, 0, 1)) {
            return;
        }
        try {
            TimeDecayingMax timeDecayingMax = this;
            synchronized (timeDecayingMax) {
                do {
                    this.ringBuffer[this.currentBucket].set(0L);
                    if (++this.currentBucket >= this.ringBuffer.length) {
                        this.currentBucket = 0;
                    }
                    this.lastRotateTimestampMillis += this.durationBetweenRotatesMillis;
                } while ((timeSinceLastRotateMillis -= this.durationBetweenRotatesMillis) >= this.durationBetweenRotatesMillis);
            }
        }
        finally {
            this.rotating = 0;
        }
    }
}

