/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.lang.Nullable;
import java.util.Objects;

public class ImmutableTag
implements Tag {
    private final String key;
    private final String value;

    public ImmutableTag(String key, String value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.key = key;
        this.value = value;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag that = (Tag)o;
        return Objects.equals(this.key, that.getKey()) && Objects.equals(this.value, that.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        return "ImmutableTag{key='" + this.key + '\'' + ", value='" + this.value + '\'' + '}';
    }
}

