/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.lang.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;

public final class Tags
implements Iterable<Tag> {
    private static final Tags EMPTY = new Tags(Collections.emptyMap());
    private final Map<String, Tag> tags;

    private Tags(Map<String, Tag> tags) {
        this.tags = Collections.unmodifiableMap(tags);
    }

    public Tags and(String key, String value) {
        return this.and(Tag.of(key, value));
    }

    public Tags and(String ... keyValues) {
        if (keyValues == null || keyValues.length == 0) {
            return this;
        }
        if (keyValues.length % 2 == 1) {
            throw new IllegalArgumentException("size must be even, it is a set of key/value pairs");
        }
        ArrayList<Tag> tags = new ArrayList<Tag>(keyValues.length / 2);
        for (int i = 0; i < keyValues.length; i += 2) {
            tags.add(Tag.of(keyValues[i], keyValues[i + 1]));
        }
        return this.and(tags);
    }

    public Tags and(Tag ... tags) {
        if (tags == null || tags.length == 0) {
            return this;
        }
        return this.and(Arrays.asList(tags));
    }

    public Tags and(@Nullable Iterable<? extends Tag> tags) {
        if (tags == null || !tags.iterator().hasNext()) {
            return this;
        }
        LinkedHashMap<String, Tag> merged = new LinkedHashMap<String, Tag>(this.tags);
        tags.forEach(tag -> merged.put(tag.getKey(), (Tag)tag));
        return new Tags(merged);
    }

    @Override
    public Iterator<Tag> iterator() {
        return this.tags.values().iterator();
    }

    public Stream<Tag> stream() {
        return this.tags.values().stream();
    }

    public int hashCode() {
        return this.tags.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.tags.equals(((Tags)obj).tags);
    }

    public static Tags concat(Iterable<? extends Tag> tags, Iterable<Tag> otherTags) {
        return Tags.of(tags).and(otherTags);
    }

    public static Tags concat(Iterable<? extends Tag> tags, String ... keyValues) {
        return Tags.of(tags).and(keyValues);
    }

    public static Tags of(Iterable<? extends Tag> tags) {
        if (tags instanceof Tags) {
            return (Tags)tags;
        }
        return Tags.empty().and(tags);
    }

    public static Tags of(String key, String value) {
        return Tags.empty().and(key, value);
    }

    public static Tags of(String ... keyValues) {
        return Tags.empty().and(keyValues);
    }

    public static Tags of(Tag ... tags) {
        return Tags.empty().and(tags);
    }

    public static Tags empty() {
        return EMPTY;
    }
}

