/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.step;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.step.StepValue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

class StepLongMax
extends StepValue<Long> {
    private final AtomicLong current = new AtomicLong(0L);

    public StepLongMax(Clock clock, long stepMillis) {
        super(clock, stepMillis);
    }

    @Override
    protected Supplier<Long> valueSupplier() {
        return () -> this.current.getAndSet(0L);
    }

    @Override
    protected Long noValue() {
        return 0L;
    }

    void record(long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException("Only positive values can be recorded.");
        }
        this.current.updateAndGet(curr -> Math.max(curr, amount));
    }
}

