/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.docs;

import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.docs.conventions.ObservationConventionsDocGenerator;
import io.micrometer.docs.metrics.MetricsDocGenerator;
import io.micrometer.docs.spans.SpansDocGenerator;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Pattern;
import picocli.CommandLine;

@CommandLine.Command(mixinStandardHelpOptions=true, description={"Generate documentation from source files"})
public class DocsGeneratorCommand
implements Runnable {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DocsGeneratorCommand.class);
    @CommandLine.ArgGroup(exclusive=false)
    private final Options options = new Options();
    @CommandLine.Parameters(index="0", description={"The project root directory."})
    private File projectRoot;
    @CommandLine.Parameters(index="1", description={"The regex pattern for inclusion."})
    private Pattern inclusionPattern;
    @CommandLine.Parameters(index="2", description={"The output directory."})
    private Path outputDir;
    @CommandLine.Option(names={"--metrics-template"}, defaultValue="templates/metrics.adoc.hbs", description={"Metrics template location"})
    private String metricsTemplate;
    @CommandLine.Option(names={"--spans-template"}, defaultValue="templates/spans.adoc.hbs", description={"Spans template location"})
    private String spansTemplate;
    @CommandLine.Option(names={"--conventions-template"}, defaultValue="templates/conventions.adoc.hbs", description={"Observation Conventions template location"})
    private String conventionsTemplate;
    @CommandLine.Option(names={"--metrics-output"}, defaultValue="_metrics.adoc", description={"Generated metrics filename. Absolute path or relative path to the output directory."})
    private Path metricsOutput;
    @CommandLine.Option(names={"--spans-output"}, defaultValue="_spans.adoc", description={"Generated metrics filename. Absolute path or relative path to the output directory."})
    private Path spansOutput;
    @CommandLine.Option(names={"--conventions-output"}, defaultValue="_conventions.adoc", description={"Generated observation conventions filename. Absolute path or relative path to the output directory."})
    private Path conventionsOutput;

    public static void main(String ... args) {
        DocsGeneratorCommand command = new DocsGeneratorCommand();
        DocsGeneratorCommand.execute(command, args);
    }

    private static void execute(Runnable runnable, String[] args) {
        CommandLine cmd = new CommandLine((Object)runnable);
        try {
            CommandLine.ParseResult parseResult = cmd.parseArgs(args);
            if (cmd.isUsageHelpRequested()) {
                cmd.usage(cmd.getOut());
                return;
            }
            if (cmd.isVersionHelpRequested()) {
                cmd.printVersionHelp(cmd.getOut());
                return;
            }
            runnable.run();
        }
        catch (CommandLine.ParameterException ex) {
            cmd.getErr().println(ex.getMessage());
            if (!CommandLine.UnmatchedArgumentException.printSuggestions((CommandLine.ParameterException)ex, (PrintWriter)cmd.getErr())) {
                ex.getCommandLine().usage(cmd.getErr());
            }
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace(cmd.getErr());
            throw ex;
        }
    }

    @Override
    public void run() {
        this.inclusionPattern = Pattern.compile(this.inclusionPattern.pattern().replace("/", File.separator));
        logger.info("Project root: {}", (Object)this.projectRoot);
        logger.info("Inclusion pattern: {}", (Object)this.inclusionPattern);
        logger.info("Output root: {}", (Object)this.outputDir);
        this.options.setAllIfNoneSpecified();
        if (this.options.metrics) {
            this.generateMetricsDoc();
        }
        if (this.options.spans) {
            this.generateSpansDoc();
        }
        if (this.options.conventions) {
            this.generateConventionsDoc();
        }
    }

    void generateMetricsDoc() {
        Path output = this.resolveAndPrepareOutputPath(this.metricsOutput);
        new MetricsDocGenerator(this.projectRoot, this.inclusionPattern, this.metricsTemplate, output).generate();
    }

    void generateSpansDoc() {
        Path output = this.resolveAndPrepareOutputPath(this.spansOutput);
        new SpansDocGenerator(this.projectRoot, this.inclusionPattern, this.spansTemplate, output).generate();
    }

    void generateConventionsDoc() {
        Path output = this.resolveAndPrepareOutputPath(this.conventionsOutput);
        new ObservationConventionsDocGenerator(this.projectRoot, this.inclusionPattern, this.conventionsTemplate, output).generate();
    }

    private Path resolveAndPrepareOutputPath(Path specified) {
        Path resolved = this.resolveOutputPath(specified);
        if (resolved.toFile().isDirectory()) {
            throw new IllegalArgumentException(resolved + " is not a file");
        }
        try {
            Files.createDirectories(resolved.getParent(), new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to prepare output directory for " + resolved, ex);
        }
        return resolved;
    }

    private Path resolveOutputPath(Path specified) {
        if (specified.isAbsolute()) {
            return specified;
        }
        return this.outputDir.resolve(specified);
    }

    static class Options {
        @CommandLine.Option(names={"--metrics"}, description={"Generate metrics documentation"})
        private boolean metrics;
        @CommandLine.Option(names={"--spans"}, description={"Generate spans documentation"})
        private boolean spans;
        @CommandLine.Option(names={"--conventions"}, description={"Generate conventions documentation"})
        private boolean conventions;

        Options() {
        }

        void setAllIfNoneSpecified() {
            if (!(this.metrics || this.spans || this.conventions)) {
                this.metrics = true;
                this.spans = true;
                this.conventions = true;
            }
        }
    }
}

