/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.docs.commons;

import io.micrometer.docs.commons.EntryEnumConstantReader;
import io.micrometer.docs.commons.EventEntry;
import io.micrometer.docs.commons.ParsingUtils;
import io.micrometer.docs.commons.utils.AsciidocUtils;
import io.micrometer.docs.commons.utils.Assert;
import io.micrometer.observation.Observation;
import org.jboss.forge.roaster.model.source.EnumConstantSource;

public class EventEntryForMetricEnumConstantReader
implements EntryEnumConstantReader<EventEntry> {
    public static final EventEntryForMetricEnumConstantReader INSTANCE = new EventEntryForMetricEnumConstantReader();

    @Override
    public Class<?> getRequiredClass() {
        return Observation.Event.class;
    }

    @Override
    public EventEntry apply(EnumConstantSource enumConstantSource) {
        String description = AsciidocUtils.javadocToAsciidoc(enumConstantSource.getJavaDoc());
        String name = ParsingUtils.enumMethodValue(enumConstantSource, "getName");
        Assert.notNull(name, "Event enum constants require readable getName() for metrics documentation.");
        EventEntry model = new EventEntry();
        model.setName(name);
        model.setDescription(description);
        return model;
    }
}

