/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.docs.commons.templates;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.CompositeTemplateLoader;
import com.github.jknack.handlebars.io.FileTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import io.micrometer.docs.commons.templates.ADocHelpers;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;

public class HandlebarsUtils {
    public static Handlebars createHandlebars() {
        ClassPathTemplateLoader classPathLoader = new ClassPathTemplateLoader("/", "");
        FileTemplateLoader fileLoader = new FileTemplateLoader("/", "");
        CompositeTemplateLoader compositeLoader = new CompositeTemplateLoader(new TemplateLoader[]{classPathLoader, fileLoader});
        Handlebars handlebars = new Handlebars((TemplateLoader)compositeLoader);
        handlebars.registerHelpers(ADocHelpers.class);
        handlebars.registerHelper("anchor", (Helper)new ADocHelpers.AnchorHelper());
        StringHelpers.register((Handlebars)handlebars);
        return handlebars;
    }

    public static Template createTemplate(String templateLocation) throws IOException {
        Handlebars handlebars = HandlebarsUtils.createHandlebars();
        String content = handlebars.getLoader().sourceAt(templateLocation).content(StandardCharsets.UTF_8);
        StringBuilder sb = new StringBuilder();
        try (Scanner scanner = new Scanner(content);){
            while (scanner.hasNext()) {
                sb.append(scanner.nextLine());
                sb.append(System.lineSeparator());
            }
        }
        return handlebars.compileInline(sb.toString());
    }
}

