/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.docs.conventions;

import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.docs.commons.utils.StringUtils;

class ObservationConventionEntry
implements Comparable<ObservationConventionEntry> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ObservationConventionEntry.class);
    private final String className;
    private final Type type;
    private final String contextClassName;

    public ObservationConventionEntry(String className, Type type, String contextClassName) {
        this.className = className;
        this.type = type;
        this.contextClassName = StringUtils.hasText(contextClassName) ? contextClassName : "Unable to resolve";
    }

    public String getClassName() {
        return this.className;
    }

    public String getContextClassName() {
        return this.contextClassName;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int compareTo(ObservationConventionEntry o) {
        int compare = this.contextClassName.compareTo(o.contextClassName);
        if (compare != 0) {
            return compare;
        }
        compare = this.type.compareTo(o.type);
        if (compare != 0) {
            return compare;
        }
        if (this.className != null) {
            return this.className.compareTo(o.className);
        }
        return compare;
    }

    public static enum Type {
        GLOBAL,
        LOCAL;

    }
}

