/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.docs.metrics;

import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.docs.MeterDocumentation;
import io.micrometer.docs.commons.AbstractSearchingFileVisitor;
import io.micrometer.docs.commons.EventEntry;
import io.micrometer.docs.commons.EventEntryForMetricEnumConstantReader;
import io.micrometer.docs.commons.JavaSourceSearchHelper;
import io.micrometer.docs.commons.KeyNameEntry;
import io.micrometer.docs.commons.KeyNameEnumConstantReader;
import io.micrometer.docs.commons.ParsingUtils;
import io.micrometer.docs.commons.utils.AsciidocUtils;
import io.micrometer.docs.commons.utils.Assert;
import io.micrometer.docs.commons.utils.StringUtils;
import io.micrometer.docs.metrics.MetricEntry;
import io.micrometer.observation.docs.ObservationDocumentation;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Expression;
import org.jboss.forge.roaster.model.source.EnumConstantSource;
import org.jboss.forge.roaster.model.source.JavaEnumSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;

class MetricSearchingFileVisitor
extends AbstractSearchingFileVisitor {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MetricSearchingFileVisitor.class);
    private final Collection<MetricEntry> entries;

    MetricSearchingFileVisitor(Pattern pattern, Collection<MetricEntry> entries, JavaSourceSearchHelper searchHelper) {
        super(pattern, searchHelper);
        this.entries = entries;
    }

    @Override
    public Collection<Class<?>> supportedInterfaces() {
        return Arrays.asList(MeterDocumentation.class, ObservationDocumentation.class);
    }

    @Override
    public void onEnumConstant(JavaEnumSource enclosingEnumSource, EnumConstantSource enumConstant) {
        MetricEntry entry = this.parseMetric(enumConstant, enclosingEnumSource);
        this.entries.add(entry);
        logger.debug("Found [" + entry.lowCardinalityKeyNames.size() + "]");
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        this.validatePrefixOnTags();
        return FileVisitResult.CONTINUE;
    }

    private void validatePrefixOnTags() {
        ArrayList<String> messages = new ArrayList<String>();
        for (MetricEntry metricEntry : this.entries) {
            String prefix = metricEntry.getPrefix();
            if (!StringUtils.hasText(prefix)) continue;
            String enumName = metricEntry.getEnumName();
            String enclosingClassName = metricEntry.getEnclosingClass();
            ArrayList<KeyNameEntry> allTags = new ArrayList<KeyNameEntry>();
            allTags.addAll(metricEntry.getLowCardinalityKeyNames());
            allTags.addAll(metricEntry.getHighCardinalityKeyNames());
            messages.addAll(this.validatePrefixOnTags(prefix, allTags, enumName, enclosingClassName));
        }
        if (!messages.isEmpty()) {
            StringBuilder sb = new StringBuilder("The following documented objects do not have properly prefixed tag keys according to their prefix() method. Please align the tag keys.");
            sb.append(System.lineSeparator()).append(System.lineSeparator());
            sb.append(messages.stream().collect(Collectors.joining(System.lineSeparator())));
            sb.append(System.lineSeparator()).append(System.lineSeparator());
            throw new IllegalStateException(sb.toString());
        }
    }

    private MetricEntry parseMetric(EnumConstantSource enumConstant, JavaEnumSource myEnum) {
        MethodSource<?> keyMethodSource;
        boolean isObservationDoc = myEnum.hasInterface(ObservationDocumentation.class);
        String description = AsciidocUtils.javadocToAsciidoc(enumConstant.getJavaDoc());
        String prefix = "";
        String baseUnit = "";
        Meter.Type type = Meter.Type.TIMER;
        ArrayList<KeyNameEntry> lowCardinalityTags = new ArrayList<KeyNameEntry>();
        ArrayList<KeyNameEntry> highCardinalityTags = new ArrayList<KeyNameEntry>();
        EnumConstantSource overridesDefaultMetricFrom = null;
        ArrayList<EventEntry> events = new ArrayList<EventEntry>();
        EnumConstantSource.Body enumConstantBody = enumConstant.getBody();
        AbstractSearchingFileVisitor.NameInfo nameInfo = this.resolveName(isObservationDoc, enumConstant, myEnum);
        MethodSource methodSource = enumConstantBody.getMethod("getKeyNames");
        if (methodSource != null) {
            lowCardinalityTags.addAll(this.retrieveEnumValues((JavaSource<?>)myEnum, (MethodSource<?>)methodSource, KeyNameEnumConstantReader.INSTANCE));
        }
        if ((methodSource = enumConstantBody.getMethod("getLowCardinalityKeyNames")) != null) {
            lowCardinalityTags.addAll(this.retrieveEnumValues((JavaSource<?>)myEnum, (MethodSource<?>)methodSource, KeyNameEnumConstantReader.INSTANCE));
        }
        if ((methodSource = enumConstantBody.getMethod("getHighCardinalityKeyNames")) != null) {
            highCardinalityTags.addAll(this.retrieveEnumValues((JavaSource<?>)myEnum, (MethodSource<?>)methodSource, KeyNameEnumConstantReader.INSTANCE));
        }
        if ((methodSource = enumConstantBody.getMethod("getPrefix")) != null) {
            prefix = ParsingUtils.readStringReturnValue(methodSource);
        }
        if ((methodSource = enumConstantBody.getMethod("getBaseUnit")) != null) {
            baseUnit = ParsingUtils.readStringReturnValue(methodSource);
        }
        if ((methodSource = enumConstantBody.getMethod("getType")) != null) {
            String value = ParsingUtils.readStringReturnValue(methodSource);
            Assert.hasText(value, "Failed to read getType() method on " + myEnum.getName());
            type = Meter.Type.valueOf((String)value);
        }
        if ((methodSource = enumConstantBody.getMethod("overridesDefaultMetricFrom")) != null) {
            Expression expression = ParsingUtils.expressionFromReturnMethodDeclaration(methodSource);
            Assert.notNull(expression, "Failed to parse the expression from " + methodSource);
            overridesDefaultMetricFrom = this.searchHelper.searchReferencingEnumConstant((JavaSource<?>)myEnum, expression);
        }
        if ((methodSource = enumConstantBody.getMethod("getEvents")) != null) {
            events.addAll(this.retrieveEnumValues((JavaSource<?>)myEnum, (MethodSource<?>)methodSource, EventEntryForMetricEnumConstantReader.INSTANCE));
        }
        String name = nameInfo.getName();
        String nameOrigin = nameInfo.getNameOrigin();
        events.forEach(event -> event.setName(name + "." + event.getName()));
        if (overridesDefaultMetricFrom != null && lowCardinalityTags.isEmpty() && (keyMethodSource = this.searchHelper.searchMethodSource((JavaSource<?>)overridesDefaultMetricFrom.getBody(), "getLowCardinalityKeyNames")) != null) {
            JavaEnumSource enclosingEnumSource = (JavaEnumSource)overridesDefaultMetricFrom.getOrigin();
            List lows = this.retrieveEnumValues((JavaSource<?>)enclosingEnumSource, keyMethodSource, KeyNameEnumConstantReader.INSTANCE);
            lowCardinalityTags.addAll(lows);
        }
        Collections.sort(lowCardinalityTags);
        Collections.sort(highCardinalityTags);
        Collections.sort(events);
        ArrayList<MetricEntry.MetricInfo> metricInfos = new ArrayList<MetricEntry.MetricInfo>();
        metricInfos.add(new MetricEntry.MetricInfo(name, nameOrigin, type, baseUnit));
        if (myEnum.hasInterface(ObservationDocumentation.class)) {
            String ltkMetricName = name + ".active";
            metricInfos.add(new MetricEntry.MetricInfo(ltkMetricName, nameOrigin, Meter.Type.LONG_TASK_TIMER, ""));
        }
        return new MetricEntry(myEnum.getCanonicalName(), enumConstant.getName(), description, prefix, lowCardinalityTags, highCardinalityTags, events, metricInfos);
    }

    private AbstractSearchingFileVisitor.NameInfo resolveName(boolean isObservationDoc, EnumConstantSource enumConstant, JavaEnumSource enclosingEnum) {
        EnumConstantSource.Body enumConstantBody = enumConstant.getBody();
        String name = "";
        MethodSource methodSource = enumConstantBody.getMethod("getName");
        if (methodSource != null) {
            name = ParsingUtils.readStringReturnValue(methodSource);
        }
        if (!isObservationDoc) {
            return new AbstractSearchingFileVisitor.NameInfo(name, "");
        }
        String conventionClassName = null;
        methodSource = enumConstantBody.getMethod("getDefaultConvention");
        if (methodSource != null) {
            conventionClassName = ParsingUtils.readStringReturnValue(methodSource);
        }
        this.validateNameOrConvention(name, conventionClassName, enclosingEnum);
        if (!StringUtils.hasText(conventionClassName)) {
            return new AbstractSearchingFileVisitor.NameInfo(name, "");
        }
        JavaSource<?> conventionClassSource = this.searchHelper.searchReferencingClass((JavaSource<?>)enclosingEnum, conventionClassName);
        if (conventionClassSource == null) {
            throw new RuntimeException("Cannot find the source java file for " + conventionClassName);
        }
        MethodSource<?> getNameMethodSource = this.searchHelper.searchMethodSource(conventionClassSource, "getName");
        if (getNameMethodSource == null) {
            throw new RuntimeException("Cannot find getName() method in the hierarchy of " + conventionClassName);
        }
        name = ParsingUtils.readStringReturnValue(getNameMethodSource);
        return new AbstractSearchingFileVisitor.NameInfo(name, conventionClassSource.getQualifiedName());
    }
}

