/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.docs.spans;

import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.docs.commons.AbstractSearchingFileVisitor;
import io.micrometer.docs.commons.EventEntry;
import io.micrometer.docs.commons.EventEntryForSpanEnumConstantReader;
import io.micrometer.docs.commons.EventValueEntryEnumConstantReader;
import io.micrometer.docs.commons.JavaSourceSearchHelper;
import io.micrometer.docs.commons.KeyNameEntry;
import io.micrometer.docs.commons.KeyNameEnumConstantReader;
import io.micrometer.docs.commons.ParsingUtils;
import io.micrometer.docs.commons.utils.AsciidocUtils;
import io.micrometer.docs.commons.utils.Assert;
import io.micrometer.docs.commons.utils.StringUtils;
import io.micrometer.docs.spans.SpanEntry;
import io.micrometer.observation.docs.ObservationDocumentation;
import io.micrometer.tracing.docs.SpanDocumentation;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Expression;
import org.jboss.forge.roaster.model.source.EnumConstantSource;
import org.jboss.forge.roaster.model.source.JavaEnumSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;

class SpanSearchingFileVisitor
extends AbstractSearchingFileVisitor {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SpanSearchingFileVisitor.class);
    private final Collection<SpanEntry> spanEntries;
    private final Set<String> overrideEnumClassNames = new HashSet<String>();

    SpanSearchingFileVisitor(Pattern pattern, Collection<SpanEntry> spanEntries, JavaSourceSearchHelper searchHelper) {
        super(pattern, searchHelper);
        this.spanEntries = spanEntries;
    }

    @Override
    public Collection<Class<?>> supportedInterfaces() {
        return Arrays.asList(SpanDocumentation.class, ObservationDocumentation.class);
    }

    @Override
    public void onEnumConstant(JavaEnumSource enclosingEnumSource, EnumConstantSource enumConstant) {
        SpanEntry entry = this.parseSpan(enumConstant, enclosingEnumSource);
        this.spanEntries.add(entry);
        logger.debug("Found [" + entry.tagKeys.size() + "] tags and [" + entry.events.size() + "] events");
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        this.removeOverrideEntries();
        this.validatePrefixOnTags();
        return FileVisitResult.CONTINUE;
    }

    private void removeOverrideEntries() {
        Set toRemove = this.spanEntries.stream().filter(spanEntry -> this.overrideEnumClassNames.contains(spanEntry.enclosingClass)).collect(Collectors.toSet());
        if (!toRemove.isEmpty()) {
            logger.debug("Will remove the span entries <" + toRemove.stream().map(s -> s.name).collect(Collectors.joining(",")) + "> because they are overridden");
        }
        this.spanEntries.removeAll(toRemove);
    }

    private void validatePrefixOnTags() {
        ArrayList<String> messages = new ArrayList<String>();
        for (SpanEntry spanEntry : this.spanEntries) {
            String prefix = spanEntry.getPrefix();
            if (!StringUtils.hasText(prefix)) continue;
            String enumName = spanEntry.getEnumName();
            String enclosingClassName = spanEntry.getEnclosingClass();
            messages.addAll(this.validatePrefixOnTags(prefix, spanEntry.getTagKeys(), enumName, enclosingClassName));
        }
        if (!messages.isEmpty()) {
            StringBuilder sb = new StringBuilder("The following documented objects do not have properly prefixed tag keys according to their prefix() method. Please align the tag keys.");
            sb.append(System.lineSeparator()).append(System.lineSeparator());
            sb.append(messages.stream().collect(Collectors.joining(System.lineSeparator())));
            sb.append(System.lineSeparator()).append(System.lineSeparator());
            throw new IllegalStateException(sb.toString());
        }
    }

    private SpanEntry parseSpan(EnumConstantSource enumConstant, JavaEnumSource myEnum) {
        boolean isObservationDoc = myEnum.hasInterface(ObservationDocumentation.class);
        String description = AsciidocUtils.javadocToAsciidoc(enumConstant.getJavaDoc());
        String prefix = "";
        ArrayList<KeyNameEntry> tags = new ArrayList<KeyNameEntry>();
        ArrayList additionalKeyNames = new ArrayList();
        ArrayList<EventEntry> events = new ArrayList<EventEntry>();
        EnumConstantSource overridesDefaultSpanFrom = null;
        EnumConstantSource.Body enumConstantBody = enumConstant.getBody();
        AbstractSearchingFileVisitor.NameInfo nameInfo = this.resolveName(isObservationDoc, enumConstant, myEnum);
        MethodSource methodSource = enumConstantBody.getMethod("getKeyNames");
        if (methodSource != null) {
            tags.addAll(this.retrieveEnumValues((JavaSource<?>)myEnum, (MethodSource<?>)methodSource, KeyNameEnumConstantReader.INSTANCE));
        }
        if ((methodSource = enumConstantBody.getMethod("getLowCardinalityKeyNames")) != null) {
            tags.addAll(this.retrieveEnumValues((JavaSource<?>)myEnum, (MethodSource<?>)methodSource, KeyNameEnumConstantReader.INSTANCE));
        }
        if ((methodSource = enumConstantBody.getMethod("getHighCardinalityKeyNames")) != null) {
            tags.addAll(this.retrieveEnumValues((JavaSource<?>)myEnum, (MethodSource<?>)methodSource, KeyNameEnumConstantReader.INSTANCE));
        }
        if ((methodSource = enumConstantBody.getMethod("getAdditionalKeyNames")) != null) {
            additionalKeyNames.addAll(this.retrieveEnumValues((JavaSource<?>)myEnum, (MethodSource<?>)methodSource, KeyNameEnumConstantReader.INSTANCE));
        }
        if ((methodSource = enumConstantBody.getMethod("getEvents")) != null) {
            if ("EventValue".equals(methodSource.getReturnType().getSimpleName())) {
                events.addAll(this.retrieveEnumValues((JavaSource<?>)myEnum, (MethodSource<?>)methodSource, EventValueEntryEnumConstantReader.INSTANCE));
            } else {
                events.addAll(this.retrieveEnumValues((JavaSource<?>)myEnum, (MethodSource<?>)methodSource, EventEntryForSpanEnumConstantReader.INSTANCE));
            }
        }
        if ((methodSource = enumConstantBody.getMethod("getPrefix")) != null) {
            prefix = ParsingUtils.readStringReturnValue(methodSource);
        }
        if ((methodSource = enumConstantBody.getMethod("overridesDefaultSpanFrom")) != null) {
            Expression expression = ParsingUtils.expressionFromReturnMethodDeclaration(methodSource);
            Assert.notNull(expression, "Failed to parse the expression from " + methodSource);
            overridesDefaultSpanFrom = this.searchHelper.searchReferencingEnumConstant((JavaSource<?>)myEnum, expression);
            if (overridesDefaultSpanFrom != null) {
                this.overrideEnumClassNames.add(((JavaEnumSource)overridesDefaultSpanFrom.getOrigin()).getQualifiedName());
            }
        }
        if (overridesDefaultSpanFrom != null && tags.isEmpty()) {
            List<KeyNameEntry> lows = this.getKeyNameEntriesFromEnumConstant(overridesDefaultSpanFrom, "getLowCardinalityKeyNames");
            List<KeyNameEntry> highs = this.getKeyNameEntriesFromEnumConstant(overridesDefaultSpanFrom, "getHighCardinalityKeyNames");
            tags.addAll(lows);
            tags.addAll(highs);
            tags.addAll(additionalKeyNames);
        }
        Collections.sort(tags);
        Collections.sort(additionalKeyNames);
        Collections.sort(events);
        String name = nameInfo.getName();
        String nameOrigin = nameInfo.getNameOrigin();
        return new SpanEntry(name, nameOrigin, myEnum.getCanonicalName(), enumConstant.getName(), description, prefix, tags, events);
    }

    private List<KeyNameEntry> getKeyNameEntriesFromEnumConstant(EnumConstantSource enumConstantSource, String methodName) {
        ArrayList<KeyNameEntry> tags = new ArrayList<KeyNameEntry>();
        MethodSource methodSource = enumConstantSource.getBody().getMethod(methodName);
        if (methodSource != null) {
            JavaEnumSource enclosingEnumSource = (JavaEnumSource)enumConstantSource.getOrigin();
            List keys = this.retrieveEnumValues((JavaSource<?>)enclosingEnumSource, (MethodSource<?>)methodSource, KeyNameEnumConstantReader.INSTANCE);
            tags.addAll(keys);
        }
        return tags;
    }

    private AbstractSearchingFileVisitor.NameInfo resolveName(boolean isObservationDoc, EnumConstantSource enumConstant, JavaEnumSource enclosingEnum) {
        EnumConstantSource.Body enumConstantBody = enumConstant.getBody();
        String name = "";
        MethodSource methodSource = enumConstantBody.getMethod("getContextualName");
        if (methodSource != null) {
            name = ParsingUtils.readStringReturnValue(methodSource);
        }
        if (!StringUtils.hasText(name) && (methodSource = enumConstantBody.getMethod("getName")) != null) {
            name = ParsingUtils.readStringReturnValue(methodSource);
        }
        if (!isObservationDoc) {
            return new AbstractSearchingFileVisitor.NameInfo(name, "");
        }
        String conventionClassName = null;
        methodSource = enumConstantBody.getMethod("getDefaultConvention");
        if (methodSource != null) {
            conventionClassName = ParsingUtils.readStringReturnValue(methodSource);
        }
        this.validateNameOrConvention(name, conventionClassName, enclosingEnum);
        if (!StringUtils.hasText(conventionClassName)) {
            return new AbstractSearchingFileVisitor.NameInfo(name, "");
        }
        JavaSource<?> conventionClassSource = this.searchHelper.searchReferencingClass((JavaSource<?>)enclosingEnum, conventionClassName);
        if (conventionClassSource == null) {
            throw new RuntimeException("Cannot find the source java file for " + conventionClassName);
        }
        MethodSource<?> getNameMethodSource = this.searchHelper.searchMethodSource(conventionClassSource, "getName");
        if (getNameMethodSource == null) {
            throw new RuntimeException("Cannot find getName() method in the hierarchy of " + conventionClassName);
        }
        name = ParsingUtils.readStringReturnValue(getNameMethodSource);
        return new AbstractSearchingFileVisitor.NameInfo(name, conventionClassSource.getQualifiedName());
    }
}

