/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.docs.commons;

import io.micrometer.docs.commons.EntryEnumConstantReader;
import io.micrometer.docs.commons.EventEntry;
import io.micrometer.docs.commons.ParsingUtils;
import io.micrometer.docs.commons.utils.AsciidocUtils;
import io.micrometer.docs.commons.utils.Assert;
import io.micrometer.tracing.docs.EventValue;
import org.jboss.forge.roaster.model.source.EnumConstantSource;

public class EventValueEntryEnumConstantReader
implements EntryEnumConstantReader<EventEntry> {
    public static final EventValueEntryEnumConstantReader INSTANCE = new EventValueEntryEnumConstantReader();

    @Override
    public Class<?> getRequiredClass() {
        return EventValue.class;
    }

    @Override
    public EventEntry apply(EnumConstantSource enumConstantSource) {
        String description = AsciidocUtils.javadocToAsciidoc(enumConstantSource.getJavaDoc());
        String value = ParsingUtils.enumMethodValue(enumConstantSource, "getValue");
        Assert.notNull(value, "EventValue enum constants require readable getValue().");
        EventEntry model = new EventEntry();
        model.setName(value);
        model.setDescription(description);
        return model;
    }
}

