/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.docs.commons.utils;

import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Javadoc;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.TagElement;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.TextElement;
import org.jboss.forge.roaster.model.source.JavaDocSource;

public class AsciidocUtils {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(AsciidocUtils.class);
    private static final String NEWLINE = System.lineSeparator();
    private static final String LINE_BREAK = " +" + NEWLINE;
    private static final String PARAGRAPH_BREAK = NEWLINE + NEWLINE;
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("\\R");

    public static final String simpleHtmlToAsciidoc(String line, boolean assumeLiOrdered) {
        String asciidoc = line.replaceAll("<p/?>", PARAGRAPH_BREAK).replaceAll("<br/?>", LINE_BREAK).replaceAll("<strong>", PARAGRAPH_BREAK + "IMPORTANT: ").replaceAll("</strong>\\h+", PARAGRAPH_BREAK).replaceAll("</?b>", "*").replaceAll("</?i>", "_").replaceAll("<ul>", NEWLINE).replaceAll("<ol>", NEWLINE).replaceAll("</[uo]l>", NEWLINE).replaceAll("<li>", NEWLINE + (assumeLiOrdered ? " 1. " : " - "));
        return asciidoc.replaceAll("<[^<>]*>", "");
    }

    public static final String simpleTagletToAsciidoc(String tagletName, List<?> tagletFragments) {
        if ("@code".equals(tagletName) || "@value".equals(tagletName)) {
            return tagletFragments.stream().map(o -> o.toString().trim()).collect(Collectors.joining(" ", "`", "`"));
        }
        if ("@link".equals(tagletName) || "@linkplain".equals(tagletName)) {
            Stream<String> stream = tagletFragments.stream().map(o -> o.toString().trim());
            if (tagletFragments.size() > 1) {
                return stream.skip(1L).collect(Collectors.joining(" "));
            }
            return stream.collect(Collectors.joining(" ", "`", "`"));
        }
        return Stream.concat(Stream.of(tagletName), tagletFragments.stream().map(o -> o.toString().trim())).collect(Collectors.joining(" ", "`{", "}`"));
    }

    public static final String javadocToAsciidoc(JavaDocSource<?> javadoc) {
        Object internal = javadoc.getInternal();
        if (!(internal instanceof Javadoc)) {
            return javadoc.getText();
        }
        Javadoc internalJavadoc = (Javadoc)internal;
        List tagList = internalJavadoc.tags();
        StringBuilder text = new StringBuilder();
        boolean openedOrderedList = false;
        for (TagElement tagElement : tagList) {
            if (tagElement.getTagName() != null) continue;
            for (Object fragment : tagElement.fragments()) {
                if (fragment instanceof TextElement) {
                    TextElement textElement = (TextElement)fragment;
                    String line2 = textElement.getText();
                    if (line2.contains("<") && line2.contains(">")) {
                        if (line2.contains("<ul>")) {
                            openedOrderedList = false;
                        }
                        if (line2.contains("<ol>")) {
                            openedOrderedList = true;
                        }
                        text.append(AsciidocUtils.simpleHtmlToAsciidoc(line2, openedOrderedList));
                        continue;
                    }
                    text.append(line2).append(' ');
                    continue;
                }
                if (fragment instanceof TagElement) {
                    TagElement tagFragment = (TagElement)fragment;
                    text.append(AsciidocUtils.simpleTagletToAsciidoc(tagFragment.getTagName(), tagFragment.fragments()));
                    continue;
                }
                LOGGER.debug("dropped fragment during javadoc to asciidoc parsing: %s", (Object)tagElement);
            }
        }
        String trimmed = NEWLINE_PATTERN.splitAsStream(text).map(line -> line.replaceAll("\\h\\h+", " ").replaceAll("\\h+$", "")).collect(Collectors.joining(System.lineSeparator()));
        return trimmed;
    }
}

