/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.docs.metrics;

import io.micrometer.core.instrument.Meter;
import io.micrometer.docs.commons.EventEntry;
import io.micrometer.docs.commons.KeyNameEntry;
import io.micrometer.docs.commons.utils.Assert;
import io.micrometer.docs.commons.utils.StringUtils;
import java.util.List;
import java.util.Objects;

class MetricEntry
implements Comparable<MetricEntry> {
    final String enclosingClass;
    final String enumName;
    final String description;
    final String prefix;
    final List<KeyNameEntry> lowCardinalityKeyNames;
    final List<EventEntry> events;
    final List<MetricInfo> metricInfos;

    MetricEntry(String enclosingClass, String enumName, String description, String prefix, List<KeyNameEntry> lowCardinalityKeyNames, List<EventEntry> events, List<MetricInfo> metricInfos) {
        Assert.hasText(description, "Observation / Meter javadoc description must not be empty. Check <" + enclosingClass + "#" + enumName + ">");
        this.enclosingClass = enclosingClass;
        this.enumName = enumName;
        this.description = description;
        this.prefix = prefix;
        this.lowCardinalityKeyNames = lowCardinalityKeyNames;
        this.events = events;
        this.metricInfos = metricInfos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricEntry that = (MetricEntry)o;
        return Objects.equals(this.enclosingClass, that.enclosingClass) && Objects.equals(this.enumName, that.enumName) && Objects.equals(this.description, that.description) && Objects.equals(this.prefix, that.prefix) && Objects.equals(this.lowCardinalityKeyNames, that.lowCardinalityKeyNames);
    }

    public int hashCode() {
        return Objects.hash(this.enclosingClass, this.enumName, this.description, this.prefix, this.lowCardinalityKeyNames);
    }

    @Override
    public int compareTo(MetricEntry o) {
        int compare = this.enumName.compareTo(o.enumName);
        if (compare != 0) {
            return compare;
        }
        return this.enclosingClass.compareTo(o.enclosingClass);
    }

    public String getDescription() {
        return this.description;
    }

    public String getEnumName() {
        return this.enumName;
    }

    public String getEnclosingClass() {
        return this.enclosingClass;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public List<KeyNameEntry> getLowCardinalityKeyNames() {
        return this.lowCardinalityKeyNames;
    }

    public List<EventEntry> getEvents() {
        return this.events;
    }

    public List<MetricInfo> getMetricInfos() {
        return this.metricInfos;
    }

    public boolean isTimerMetric() {
        return this.metricInfos.stream().anyMatch(info -> Meter.Type.TIMER.equals((Object)info.getType()) || Meter.Type.LONG_TASK_TIMER.equals((Object)info.getType()));
    }

    public static class MetricInfo {
        final String name;
        final String nameOrigin;
        final Meter.Type type;
        final String baseUnit;

        public MetricInfo(String name, String nameOrigin, Meter.Type type, String baseUnit) {
            this.name = name;
            this.nameOrigin = nameOrigin;
            this.type = type;
            this.baseUnit = baseUnit;
        }

        public String getName() {
            return this.name;
        }

        public Meter.Type getType() {
            return this.type;
        }

        public String getBaseUnit() {
            return this.baseUnit;
        }

        public String getMetricName() {
            StringBuilder sb = new StringBuilder();
            if (StringUtils.hasText(this.name)) {
                sb.append("`").append(this.name).append("`");
                if (StringUtils.hasText(this.nameOrigin)) {
                    sb.append(" (defined by convention class `").append(this.nameOrigin).append("`)");
                }
            } else {
                sb.append("Unable to resolve the name - please check the convention class `");
                sb.append(this.nameOrigin).append("` for more details");
            }
            return sb.toString();
        }
    }
}

