/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.docs.spans;

import com.github.jknack.handlebars.Template;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.docs.commons.JavaSourceSearchHelper;
import io.micrometer.docs.commons.templates.HandlebarsUtils;
import io.micrometer.docs.spans.SpanEntry;
import io.micrometer.docs.spans.SpanSearchingFileVisitor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class SpansDocGenerator {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SpansDocGenerator.class);
    private final File projectRoot;
    private final Pattern inclusionPattern;
    private final String templateLocation;
    private final Path output;

    public SpansDocGenerator(File projectRoot, Pattern inclusionPattern, String templateLocation, Path output) {
        this.projectRoot = projectRoot;
        this.inclusionPattern = inclusionPattern;
        this.templateLocation = templateLocation;
        this.output = output;
    }

    public void generate() {
        Path path = this.projectRoot.toPath();
        logger.debug("Path is [" + this.projectRoot.getAbsolutePath() + "]. Inclusion pattern is [" + this.inclusionPattern + "]");
        JavaSourceSearchHelper searchHelper = JavaSourceSearchHelper.create(path, this.inclusionPattern);
        TreeSet<SpanEntry> spanEntries = new TreeSet<SpanEntry>();
        SpanSearchingFileVisitor fv = new SpanSearchingFileVisitor(this.inclusionPattern, spanEntries, searchHelper);
        try {
            Files.walkFileTree(path, fv);
            this.printSpansAdoc(spanEntries);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void printSpansAdoc(Collection<SpanEntry> spanEntries) throws IOException {
        Template template = HandlebarsUtils.createTemplate(this.templateLocation);
        HashMap<String, Collection<SpanEntry>> map = new HashMap<String, Collection<SpanEntry>>();
        map.put("entries", spanEntries);
        String result = template.apply(map);
        Files.write(this.output, result.getBytes(), new OpenOption[0]);
    }
}

