/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.jakarta9.instrument.mail;

import io.micrometer.jakarta9.instrument.mail.DefaultMailSendObservationConvention;
import io.micrometer.jakarta9.instrument.mail.MailObservationDocumentation;
import io.micrometer.jakarta9.instrument.mail.MailSendObservationContext;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import org.jspecify.annotations.Nullable;

public class InstrumentedTransport
extends Transport {
    private static final DefaultMailSendObservationConvention DEFAULT_CONVENTION = new DefaultMailSendObservationConvention();
    private final ObservationRegistry observationRegistry;
    private final Transport delegate;
    private final @Nullable String protocol;
    private @Nullable String host;
    private int port;
    private final @Nullable ObservationConvention<MailSendObservationContext> customConvention;

    public InstrumentedTransport(Session session, Transport delegate, ObservationRegistry observationRegistry) {
        this(session, delegate, observationRegistry, null);
    }

    public InstrumentedTransport(Session session, Transport delegate, ObservationRegistry observationRegistry, @Nullable ObservationConvention<MailSendObservationContext> customConvention) {
        super(session, delegate.getURLName());
        this.protocol = this.url.getProtocol();
        this.delegate = delegate;
        this.observationRegistry = observationRegistry;
        this.customConvention = customConvention;
    }

    public void connect(String host, int port, String user, String password) throws MessagingException {
        this.delegate.connect(host, port, user, password);
        this.host = host;
        this.port = port;
    }

    public void sendMessage(Message msg, Address[] addresses) throws MessagingException {
        Observation observation = MailObservationDocumentation.MAIL_SEND.observation(this.customConvention, DEFAULT_CONVENTION, () -> new MailSendObservationContext(msg, this.protocol, this.host, this.port), this.observationRegistry);
        observation.start();
        try (Observation.Scope ignore = observation.openScope();){
            this.delegate.sendMessage(msg, addresses);
            DEFAULT_CONVENTION.smtpMessageId(msg).ifPresent(arg_0 -> ((Observation)observation).highCardinalityKeyValue(arg_0));
        }
        catch (MessagingException error) {
            observation.error((Throwable)error);
            throw error;
        }
        finally {
            observation.stop();
        }
    }

    public synchronized void close() throws MessagingException {
        this.delegate.close();
        this.host = null;
        this.port = 0;
    }
}

