/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.observation.tck;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationRegistry;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public abstract class ConcreteContextObservationHandlerCompatibilityKit<T extends Observation.Context> {
    protected ObservationHandler<T> handler;
    protected ObservationRegistry observationRegistry = ObservationRegistry.create();
    protected Observation sample = Observation.createNotStarted((String)"hello", (ObservationRegistry)this.observationRegistry);

    public abstract ObservationHandler<T> handler();

    public abstract T context();

    @BeforeEach
    void setup() {
        this.handler = this.handler();
    }

    @Test
    @DisplayName(value="compatibility test provides a concrete context accepting observation handler")
    void handlerSupportsConcreteContextForHandlerMethods() {
        Assertions.assertThatCode(() -> this.handler.onStart(this.context())).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.handler.onStop(this.context())).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.handler.onError(this.context())).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.handler.onEvent(Observation.Event.of((String)"testEvent"), this.context())).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.handler.onScopeOpened(this.context())).doesNotThrowAnyException();
    }

    @Test
    void handlerSupportsConcreteContextOnly() {
        Assertions.assertThatCode(() -> this.handler.supportsContext(this.context())).doesNotThrowAnyException();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.handler.supportsContext(this.context())).as("Handler supports only concrete context", new Object[0])).isTrue();
        Assertions.assertThatCode(() -> this.handler.supportsContext(null)).doesNotThrowAnyException();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.handler.supportsContext(null)).as("Handler supports only concrete context - no nulls accepted", new Object[0])).isFalse();
        Assertions.assertThatCode(() -> this.handler.supportsContext((Observation.Context)new NotMatchingContext())).doesNotThrowAnyException();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.handler.supportsContext((Observation.Context)new NotMatchingContext())).as("Handler supports only concrete context", new Object[0])).isFalse();
    }

    static class NotMatchingContext
    extends Observation.Context {
        NotMatchingContext() {
        }
    }
}

