/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.observation.tck;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationRegistry;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public abstract class NullContextObservationHandlerCompatibilityKit {
    protected ObservationHandler<Observation.Context> handler;
    protected ObservationRegistry observationRegistry = ObservationRegistry.create();
    protected Observation sample = Observation.createNotStarted((String)"hello", (ObservationRegistry)this.observationRegistry);

    public abstract ObservationHandler<Observation.Context> handler();

    @BeforeEach
    void setup() {
        this.handler = this.handler();
    }

    @Test
    @DisplayName(value="compatibility test provides a null context accepting observation handler")
    void handlerSupportsNullContext() {
        Assertions.assertThatCode(() -> this.handler.onStart(null)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.handler.onStop(null)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.handler.onError(null)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.handler.onEvent(null, null)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.handler.onScopeOpened(null)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.handler.onScopeClosed(null)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.handler.onScopeReset(null)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.handler.supportsContext(null)).doesNotThrowAnyException();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.handler.supportsContext(null)).as("Handler supports null context", new Object[0])).isTrue();
    }
}

