/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.observation.tck;

import io.micrometer.observation.NullObservation;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.tck.InvalidObservationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;

class ObservationValidator
implements ObservationHandler<Observation.Context> {
    private final Consumer<ValidationResult> consumer;
    private final Predicate<Observation.Context> supportsContextPredicate;

    ObservationValidator() {
        this(ObservationValidator::throwInvalidObservationException);
    }

    ObservationValidator(Consumer<ValidationResult> consumer) {
        this(consumer, context -> !(context instanceof NullObservation.NullContext));
    }

    ObservationValidator(Consumer<ValidationResult> consumer, Predicate<Observation.Context> supportsContextPredicate) {
        this.consumer = consumer;
        this.supportsContextPredicate = supportsContextPredicate;
    }

    public void onStart(Observation.Context context) {
        this.addHistoryElement(context, InvalidObservationException.EventName.START);
        Status status = (Status)context.get(Status.class);
        if (status != null) {
            this.consumer.accept(new ValidationResult("Invalid start: Observation '" + context.getName() + "' has already been started", context));
        } else {
            context.put(Status.class, (Object)new Status());
        }
    }

    public void onError(Observation.Context context) {
        this.addHistoryElement(context, InvalidObservationException.EventName.ERROR);
        this.checkIfObservationWasStartedButNotStopped("Invalid error signal", context);
    }

    public void onEvent(Observation.Event event, Observation.Context context) {
        this.addHistoryElement(context, InvalidObservationException.EventName.EVENT);
        this.checkIfObservationWasStartedButNotStopped("Invalid event signal", context);
    }

    public void onScopeOpened(Observation.Context context) {
        this.addHistoryElement(context, InvalidObservationException.EventName.SCOPE_OPEN);
        this.checkIfObservationWasStarted("Invalid scope opening", context);
    }

    public void onScopeClosed(Observation.Context context) {
        this.addHistoryElement(context, InvalidObservationException.EventName.SCOPE_CLOSE);
        this.checkIfObservationWasStarted("Invalid scope closing", context);
    }

    public void onScopeReset(Observation.Context context) {
        this.addHistoryElement(context, InvalidObservationException.EventName.SCOPE_RESET);
        this.checkIfObservationWasStarted("Invalid scope resetting", context);
    }

    public void onStop(Observation.Context context) {
        this.addHistoryElement(context, InvalidObservationException.EventName.STOP);
        Status status = this.checkIfObservationWasStartedButNotStopped("Invalid stop", context);
        if (status != null) {
            status.markStopped();
        }
    }

    public boolean supportsContext(Observation.Context context) {
        return this.supportsContextPredicate.test(context);
    }

    private void addHistoryElement(Observation.Context context, InvalidObservationException.EventName eventName) {
        History history = (History)context.computeIfAbsent(History.class, clazz -> new History());
        history.addHistoryElement(eventName);
    }

    private @Nullable Status checkIfObservationWasStarted(String prefix, Observation.Context context) {
        Status status = (Status)context.get(Status.class);
        if (status == null) {
            this.consumer.accept(new ValidationResult(prefix + ": Observation '" + context.getName() + "' has not been started yet", context));
        }
        return status;
    }

    private @Nullable Status checkIfObservationWasStartedButNotStopped(String prefix, Observation.Context context) {
        Status status = this.checkIfObservationWasStarted(prefix, context);
        if (status != null && status.isStopped()) {
            this.consumer.accept(new ValidationResult(prefix + ": Observation '" + context.getName() + "' has already been stopped", context));
        }
        return status;
    }

    private static void throwInvalidObservationException(ValidationResult validationResult) {
        History history = (History)validationResult.getContext().getOrDefault(History.class, () -> new History());
        throw new InvalidObservationException(validationResult.getMessage(), validationResult.getContext(), history.getHistoryElements());
    }

    static class Status {
        private boolean stopped = false;

        Status() {
        }

        boolean isStopped() {
            return this.stopped;
        }

        void markStopped() {
            this.stopped = true;
        }
    }

    static class ValidationResult {
        private final String message;
        private final Observation.Context context;

        ValidationResult(String message, Observation.Context context) {
            this.message = message;
            this.context = context;
        }

        String getMessage() {
            return this.message;
        }

        Observation.Context getContext() {
            return this.context;
        }

        public String toString() {
            return this.getMessage() + " - " + this.getContext();
        }
    }

    static class History {
        private final List<InvalidObservationException.HistoryElement> historyElements = new ArrayList<InvalidObservationException.HistoryElement>();

        History() {
        }

        private void addHistoryElement(InvalidObservationException.EventName eventName) {
            this.historyElements.add(new InvalidObservationException.HistoryElement(eventName));
        }

        List<InvalidObservationException.HistoryElement> getHistoryElements() {
            return Collections.unmodifiableList(this.historyElements);
        }
    }
}

