/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheus.internal;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.prometheus.internal.CustomCollectorChild;
import io.prometheus.client.Collector;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class CustomPrometheusLongTaskTimer
extends Collector {
    private final Clock clock;
    private final String name;
    private final String activeTasksName;
    private final String durationName;
    private final String description;
    private final List<String> tagKeys;
    private final Collection<Child> children = new ConcurrentLinkedQueue<Child>();

    public CustomPrometheusLongTaskTimer(Meter.Id id, Clock clock) {
        this.name = id.getConventionName();
        this.description = id.getDescription();
        this.clock = clock;
        this.tagKeys = id.getConventionTags().stream().map(Tag::getKey).collect(Collectors.toList());
        this.activeTasksName = this.name + "_active_count";
        this.durationName = this.name + "_sum";
    }

    public Child child(Iterable<Tag> tags) {
        Child child = new Child(tags);
        this.children.add(child);
        return child;
    }

    public List<Collector.MetricFamilySamples> collect() {
        return Collections.singletonList(new Collector.MetricFamilySamples(this.name, Collector.Type.UNTYPED, this.description == null ? " " : this.description, this.children.stream().flatMap(Child::collect).collect(Collectors.toList())));
    }

    public class Child
    implements CustomCollectorChild {
        private final List<String> tagValues;
        private final ConcurrentMap<Long, Long> tasks = new ConcurrentHashMap<Long, Long>();
        private final AtomicLong nextTask = new AtomicLong(0L);

        Child(Iterable<Tag> tags) {
            this.tagValues = StreamSupport.stream(tags.spliterator(), false).map(Tag::getValue).collect(Collectors.toList());
        }

        @Override
        public Stream<Collector.MetricFamilySamples.Sample> collect() {
            Stream.Builder<Collector.MetricFamilySamples.Sample> samples = Stream.builder();
            samples.add(new Collector.MetricFamilySamples.Sample(CustomPrometheusLongTaskTimer.this.activeTasksName, CustomPrometheusLongTaskTimer.this.tagKeys, this.tagValues, (double)this.activeTasks()));
            samples.add(new Collector.MetricFamilySamples.Sample(CustomPrometheusLongTaskTimer.this.durationName, CustomPrometheusLongTaskTimer.this.tagKeys, this.tagValues, this.duration(TimeUnit.SECONDS)));
            return samples.build();
        }

        public long start() {
            long task = this.nextTask.getAndIncrement();
            this.tasks.put(task, CustomPrometheusLongTaskTimer.this.clock.monotonicTime());
            return task;
        }

        public long stop(long task) {
            Long startTime = (Long)this.tasks.get(task);
            if (startTime != null) {
                this.tasks.remove(task);
                return CustomPrometheusLongTaskTimer.this.clock.monotonicTime() - startTime;
            }
            return -1L;
        }

        public double duration(long task, TimeUnit unit) {
            Long startTime = (Long)this.tasks.get(task);
            return startTime != null ? TimeUtils.nanosToUnit((double)(CustomPrometheusLongTaskTimer.this.clock.monotonicTime() - startTime), (TimeUnit)unit) : -1.0;
        }

        public double duration(TimeUnit unit) {
            long now = CustomPrometheusLongTaskTimer.this.clock.monotonicTime();
            long sum = 0L;
            Iterator iterator = this.tasks.values().iterator();
            while (iterator.hasNext()) {
                long startTime = (Long)iterator.next();
                sum += now - startTime;
            }
            return TimeUtils.nanosToUnit((double)sum, (TimeUnit)unit);
        }

        public int activeTasks() {
            return this.tasks.size();
        }
    }
}

