/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.atlas;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.api.histogram.PercentileDistributionSummary;
import com.netflix.spectator.api.histogram.PercentileTimer;
import com.netflix.spectator.atlas.AtlasConfig;
import com.netflix.spectator.atlas.AtlasRegistry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.NamingConvention;
import io.micrometer.core.instrument.spectator.SpectatorDistributionSummary;
import io.micrometer.core.instrument.spectator.SpectatorTimer;
import io.micrometer.core.instrument.spectator.step.StepSpectatorMeterRegistry;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.hist.PercentileHistogram;
import io.micrometer.core.instrument.stats.hist.PercentileTimeHistogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import java.util.function.UnaryOperator;

public class AtlasMeterRegistry
extends StepSpectatorMeterRegistry {
    public AtlasMeterRegistry(AtlasConfig config, final Clock clock) {
        super(null, (Registry)new AtlasRegistry(new com.netflix.spectator.api.Clock(){

            public long wallTime() {
                return clock.wallTime();
            }

            public long monotonicTime() {
                return clock.monotonicTime();
            }
        }, config), clock, config.step().toMillis());
        this.config().namingConvention(NamingConvention.camelCase);
        this.start();
    }

    public AtlasMeterRegistry(AtlasConfig config) {
        this(config, Clock.SYSTEM);
    }

    public void start() {
        this.getAtlasRegistry().start();
    }

    public void stop() {
        this.getAtlasRegistry().stop();
    }

    private AtlasRegistry getAtlasRegistry() {
        return (AtlasRegistry)this.getSpectatorRegistry();
    }

    protected io.micrometer.core.instrument.Timer newTimer(Meter.Id id, Histogram.Builder<?> histogram, Quantiles quantiles) {
        if (histogram != null && histogram.create(Histogram.Summation.Normal) instanceof PercentileTimeHistogram) {
            this.registerQuantilesGaugeIfNecessary(id, quantiles, t -> t / 1000000.0);
            PercentileTimer timer = PercentileTimer.get((Registry)this.getSpectatorRegistry(), (Id)this.getSpectatorRegistry().createId(this.getConventionName(id), (Iterable)this.toSpectatorTags(this.getConventionTags(id))));
            return new SpectatorTimer(id, (Timer)timer, this.clock, quantiles, null);
        }
        return super.newTimer(id, histogram, quantiles);
    }

    protected DistributionSummary newDistributionSummary(Meter.Id id, Histogram.Builder<?> histogram, Quantiles quantiles) {
        if (histogram != null && histogram.create(Histogram.Summation.Normal) instanceof PercentileHistogram) {
            this.registerQuantilesGaugeIfNecessary(id, quantiles, UnaryOperator.identity());
            PercentileDistributionSummary ds = PercentileDistributionSummary.get((Registry)this.getSpectatorRegistry(), (Id)this.getSpectatorRegistry().createId(this.getConventionName(id), (Iterable)this.toSpectatorTags(this.getConventionTags(id))));
            return new SpectatorDistributionSummary(id, (com.netflix.spectator.api.DistributionSummary)ds, quantiles, null);
        }
        return super.newDistributionSummary(id, histogram, quantiles);
    }
}

