/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.atlas;

import com.netflix.spectator.api.AbstractMeter;
import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.LongTaskTimer;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.api.histogram.PercentileDistributionSummary;
import com.netflix.spectator.api.histogram.PercentileTimer;
import com.netflix.spectator.atlas.AtlasConfig;
import com.netflix.spectator.atlas.AtlasRegistry;
import io.micrometer.atlas.AtlasUtils;
import io.micrometer.atlas.SpectatorCounter;
import io.micrometer.atlas.SpectatorDistributionSummary;
import io.micrometer.atlas.SpectatorGauge;
import io.micrometer.atlas.SpectatorLongTaskTimer;
import io.micrometer.atlas.SpectatorTimer;
import io.micrometer.atlas.SpectatorToDoubleGauge;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.histogram.pause.PauseDetector;
import io.micrometer.core.instrument.internal.DefaultMeter;
import io.micrometer.core.instrument.step.StepFunctionCounter;
import io.micrometer.core.instrument.step.StepFunctionTimer;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class AtlasMeterRegistry
extends MeterRegistry {
    private final AtlasRegistry registry;
    private final DecimalFormat percentileFormat = new DecimalFormat("#.####");
    private final AtlasConfig atlasConfig;

    public AtlasMeterRegistry(AtlasConfig config, final Clock clock) {
        super(clock);
        this.atlasConfig = config;
        this.registry = new AtlasRegistry(new com.netflix.spectator.api.Clock(){

            public long wallTime() {
                return clock.wallTime();
            }

            public long monotonicTime() {
                return clock.monotonicTime();
            }
        }, config);
        this.config().namingConvention(NamingConvention.camelCase);
        this.start();
    }

    public AtlasMeterRegistry(AtlasConfig config) {
        this(config, Clock.SYSTEM);
    }

    public void start() {
        this.getAtlasRegistry().start();
    }

    public void stop() {
        this.getAtlasRegistry().stop();
    }

    private AtlasRegistry getAtlasRegistry() {
        return (AtlasRegistry)this.getSpectatorRegistry();
    }

    protected Counter newCounter(Meter.Id id) {
        return new SpectatorCounter(id, this.registry.counter(this.spectatorId(id)));
    }

    protected DistributionSummary newDistributionSummary(Meter.Id id, HistogramConfig histogramConfig) {
        com.netflix.spectator.api.DistributionSummary internalSummary = this.registry.distributionSummary(this.spectatorId(id));
        if (histogramConfig.isPercentileHistogram().booleanValue()) {
            PercentileDistributionSummary.get((Registry)this.registry, (Id)this.spectatorId(id));
        }
        SpectatorDistributionSummary summary = new SpectatorDistributionSummary(id, internalSummary, this.clock, histogramConfig);
        for (long sla : histogramConfig.getSlaBoundaries()) {
            this.gauge(id.getName(), Tags.concat((Iterable)this.getConventionTags(id), (String[])new String[]{"sla", Long.toString(sla)}), sla, arg_0 -> ((SpectatorDistributionSummary)summary).histogramCountAtValue(arg_0));
        }
        for (double percentile : histogramConfig.getPercentiles()) {
            this.gauge(id.getName(), Tags.concat((Iterable)this.getConventionTags(id), (String[])new String[]{"percentile", this.percentileFormat.format(percentile)}), (Object)summary, s -> s.percentile(percentile));
        }
        return summary;
    }

    protected io.micrometer.core.instrument.Timer newTimer(Meter.Id id, HistogramConfig histogramConfig, PauseDetector pauseDetector) {
        Timer internalTimer = this.registry.timer(this.spectatorId(id));
        if (histogramConfig.isPercentileHistogram().booleanValue()) {
            PercentileTimer.get((Registry)this.registry, (Id)this.spectatorId(id));
        }
        SpectatorTimer timer = new SpectatorTimer(id, internalTimer, this.clock, histogramConfig, pauseDetector, this.getBaseTimeUnit());
        for (long sla : histogramConfig.getSlaBoundaries()) {
            this.gauge(id.getName(), Tags.concat((Iterable)this.getConventionTags(id), (String[])new String[]{"sla", Duration.ofNanos(sla).toString()}), sla, arg_0 -> ((SpectatorTimer)timer).histogramCountAtValue(arg_0));
        }
        for (double percentile : histogramConfig.getPercentiles()) {
            this.gauge(id.getName(), Tags.concat((Iterable)this.getConventionTags(id), (String[])new String[]{"percentile", this.percentileFormat.format(percentile)}), (Object)timer, t -> t.percentile(percentile, TimeUnit.SECONDS));
        }
        return timer;
    }

    private Id spectatorId(Meter.Id id) {
        List tags = this.getConventionTags(id).stream().map(t -> new BasicTag(t.getKey(), t.getValue())).collect(Collectors.toList());
        return this.registry.createId(this.getConventionName(id), tags);
    }

    protected <T> Gauge newGauge(Meter.Id id, T obj, ToDoubleFunction<T> f) {
        SpectatorToDoubleGauge<T> gauge = new SpectatorToDoubleGauge<T>(this.registry.clock(), this.spectatorId(id), obj, f);
        this.registry.register(gauge);
        return new SpectatorGauge(id, gauge);
    }

    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> f) {
        StepFunctionCounter fc = new StepFunctionCounter(id, this.clock, this.atlasConfig.step().toMillis(), obj, f);
        this.newMeter(id, Meter.Type.Counter, fc.measure());
        return fc;
    }

    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnits) {
        StepFunctionTimer ft = new StepFunctionTimer(id, this.clock, this.atlasConfig.step().toMillis(), obj, countFunction, totalTimeFunction, totalTimeFunctionUnits, this.getBaseTimeUnit());
        this.newMeter(id, Meter.Type.Timer, ft.measure());
        return ft;
    }

    protected io.micrometer.core.instrument.LongTaskTimer newLongTaskTimer(Meter.Id id) {
        return new SpectatorLongTaskTimer(id, (LongTaskTimer)com.netflix.spectator.api.patterns.LongTaskTimer.get((Registry)this.registry, (Id)this.spectatorId(id)));
    }

    protected Meter newMeter(Meter.Id id, Meter.Type type, final Iterable<Measurement> measurements) {
        Id spectatorId = this.spectatorId(id);
        AbstractMeter<Id> spectatorMeter = new AbstractMeter<Id>(this.registry.clock(), spectatorId, spectatorId){

            public Iterable<com.netflix.spectator.api.Measurement> measure() {
                return StreamSupport.stream(measurements.spliterator(), false).map(m -> {
                    Statistic stat = AtlasUtils.toSpectatorStatistic(m.getStatistic());
                    Id idWithStat = stat == null ? this.id : this.id.withTag("statistic", stat.toString());
                    return new com.netflix.spectator.api.Measurement(idWithStat, this.clock.wallTime(), m.getValue());
                }).collect(Collectors.toList());
            }
        };
        this.registry.register((com.netflix.spectator.api.Meter)spectatorMeter);
        return new DefaultMeter(id, type, measurements);
    }

    public Registry getSpectatorRegistry() {
        return this.registry;
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }

    protected HistogramConfig defaultHistogramConfig() {
        return HistogramConfig.builder().histogramExpiry(this.atlasConfig.step()).build().merge(HistogramConfig.DEFAULT);
    }
}

