/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.atlas;

import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Statistic;
import io.micrometer.core.instrument.AbstractDistributionSummary;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.util.MeterEquivalence;
import java.util.stream.StreamSupport;

public class SpectatorDistributionSummary
extends AbstractDistributionSummary {
    private final DistributionSummary summary;

    SpectatorDistributionSummary(Meter.Id id, DistributionSummary distributionSummary, Clock clock, HistogramConfig histogramConfig) {
        super(id, clock, histogramConfig);
        this.summary = distributionSummary;
    }

    protected void recordNonNegative(double amount) {
        this.summary.record((long)amount);
    }

    public long count() {
        return this.summary.count();
    }

    public double totalAmount() {
        return this.summary.totalAmount();
    }

    public double max() {
        for (Measurement measurement : this.summary.measure()) {
            if (!StreamSupport.stream(measurement.id().tags().spliterator(), false).anyMatch(tag -> tag.key().equals("statistic") && tag.value().equals(Statistic.max.toString()))) continue;
            return measurement.value();
        }
        return Double.NaN;
    }

    public boolean equals(Object o) {
        return MeterEquivalence.equals((Meter)this, (Object)o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode((Meter)this);
    }
}

