/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.datadog;

import io.micrometer.core.instrument.config.MissingRequiredConfigurationException;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.lang.Nullable;

public interface DatadogConfig
extends StepRegistryConfig {
    public static final DatadogConfig DEFAULT = k -> null;

    default public String prefix() {
        return "datadog";
    }

    default public String apiKey() {
        String v = this.get(this.prefix() + ".apiKey");
        if (v == null) {
            throw new MissingRequiredConfigurationException("apiKey must be set to report metrics to Datadog");
        }
        return v;
    }

    @Nullable
    default public String applicationKey() {
        return this.get(this.prefix() + ".applicationKey");
    }

    @Nullable
    default public String hostTag() {
        String v = this.get(this.prefix() + ".hostTag");
        return v == null ? "instance" : v;
    }

    default public String uri() {
        String v = this.get(this.prefix() + ".uri");
        return v == null ? "https://app.datadoghq.com" : v;
    }

    default public boolean descriptions() {
        String v = this.get(this.prefix() + ".descriptions");
        return v == null || Boolean.valueOf(v) != false;
    }
}

