/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.datadog;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.lang.Nullable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;

class DatadogMetricMetadata {
    private static final Set<String> UNIT_WHITELIST = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("bit", "byte", "kibibyte", "mebibyte", "gibibyte", "tebibyte", "pebibyte", "exbibyte", "microsecond", "millisecond", "second", "minute", "hour", "day", "week", "nanosecond", "fraction", "percent", "percent_nano", "apdex", "connection", "request", "packet", "segment", "response", "message", "payload", "timeout", "datagram", "route", "session", "process", "core", "thread", "host", "node", "fault", "service", "instance", "cpu", "file", "inode", "sector", "block", "buffer", "error", "read", "write", "occurrence", "event", "time", "unit", "operation", "item", "task", "worker", "resource", "email", "sample", "stage", "monitor", "location", "check", "attempt", "device", "update", "method", "job", "container", "table", "index", "lock", "transaction", "query", "row", "key", "command", "offset", "record", "object", "cursor", "assertion", "scan", "document", "shard", "flush", "merge", "refresh", "fetch", "column", "commit", "wait", "ticket", "question", "hit", "miss", "eviction", "get", "set", "dollar", "cent", "page", "split", "hertz", "kilohertz", "megahertz", "gigahertz", "entry")));
    private static final Map<String, String> PLURALIZED_UNIT_MAPPING;
    private final Meter.Id id;
    private final String type;
    private final boolean descriptionsEnabled;
    @Nullable
    private final String overrideBaseUnit;

    DatadogMetricMetadata(Meter.Id id, Statistic statistic, boolean descriptionsEnabled, @Nullable String overrideBaseUnit) {
        this.id = id;
        this.descriptionsEnabled = descriptionsEnabled;
        this.overrideBaseUnit = overrideBaseUnit;
        switch (statistic) {
            case COUNT: 
            case TOTAL: 
            case TOTAL_TIME: {
                this.type = "count";
                break;
            }
            default: {
                this.type = "gauge";
            }
        }
    }

    String editMetadataBody() {
        String baseUnit;
        String body = "{\"type\":\"" + this.type + "\"";
        String string = baseUnit = this.overrideBaseUnit != null ? this.overrideBaseUnit : this.id.getBaseUnit();
        if (baseUnit != null) {
            String whitelistedBaseUnit;
            String string2 = whitelistedBaseUnit = UNIT_WHITELIST.contains(baseUnit) ? baseUnit : PLURALIZED_UNIT_MAPPING.get(baseUnit);
            if (whitelistedBaseUnit != null) {
                body = body + ",\"unit\":\"" + whitelistedBaseUnit + "\"";
            }
        }
        if (this.descriptionsEnabled && this.id.getDescription() != null) {
            body = body + ",\"description\":\"" + StringEscapeUtils.escapeJson((String)this.id.getDescription()) + "\"";
        }
        body = body + "}";
        return body;
    }

    static {
        HashMap<String, String> pluralizedUnitMapping = new HashMap<String, String>();
        UNIT_WHITELIST.forEach(unit -> pluralizedUnitMapping.put(unit + "s", (String)unit));
        pluralizedUnitMapping.put("indices", "index");
        pluralizedUnitMapping.put("indexes", "index");
        PLURALIZED_UNIT_MAPPING = Collections.unmodifiableMap(pluralizedUnitMapping);
    }
}

