/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.dynatrace.types;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;

final class DynatraceSummary {
    private final LongAdder count = new LongAdder();
    private final DoubleAdder total = new DoubleAdder();
    private final AtomicLong min = new AtomicLong();
    private final AtomicLong max = new AtomicLong();

    DynatraceSummary() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordNonNegative(double amount) {
        if (amount < 0.0) {
            return;
        }
        long longBits = Double.doubleToLongBits(amount);
        DynatraceSummary dynatraceSummary = this;
        synchronized (dynatraceSummary) {
            this.max.getAndUpdate(prev -> Math.max(prev, longBits));
            this.min.getAndUpdate(prev -> this.count.longValue() > 0L ? Math.min(prev, longBits) : longBits);
            this.total.add(amount);
            this.count.increment();
        }
    }

    long getCount() {
        return this.count.longValue();
    }

    double getTotal() {
        return this.total.doubleValue();
    }

    double getMin() {
        return Double.longBitsToDouble(this.min.longValue());
    }

    double getMax() {
        return Double.longBitsToDouble(this.max.longValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        DynatraceSummary dynatraceSummary = this;
        synchronized (dynatraceSummary) {
            this.min.set(0L);
            this.max.set(0L);
            this.total.reset();
            this.count.reset();
        }
    }
}

