/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.dynatrace;

import com.dynatrace.file.util.DynatraceFileBasedConfigurationProvider;
import com.dynatrace.metric.util.DynatraceMetricApiConstants;
import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.config.MeterRegistryConfig;
import io.micrometer.core.instrument.config.MeterRegistryConfigValidator;
import io.micrometer.core.instrument.config.validate.PropertyValidator;
import io.micrometer.core.instrument.config.validate.Validated;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.dynatrace.DynatraceApiVersion;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;

public interface DynatraceConfig
extends StepRegistryConfig {
    public static final DynatraceConfig DEFAULT = k -> null;

    default public String prefix() {
        return "dynatrace";
    }

    default public String apiToken() {
        Validated secret = PropertyValidator.getSecret((MeterRegistryConfig)this, (String)"apiToken");
        if (this.apiVersion() == DynatraceApiVersion.V1) {
            return (String)secret.required().get();
        }
        return (String)secret.orElse((Object)(this.uri().equals(DynatraceMetricApiConstants.getDefaultOneAgentEndpoint()) ? "" : DynatraceFileBasedConfigurationProvider.getInstance().getMetricIngestToken()));
    }

    default public String uri() {
        Validated uri = PropertyValidator.getUrlString((MeterRegistryConfig)this, (String)"uri");
        if (this.apiVersion() == DynatraceApiVersion.V1) {
            return (String)uri.required().get();
        }
        return (String)uri.orElse((Object)DynatraceFileBasedConfigurationProvider.getInstance().getMetricIngestEndpoint());
    }

    default public String deviceId() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"deviceId").orElse((Object)"");
    }

    default public String technologyType() {
        return (String)PropertyValidator.getSecret((MeterRegistryConfig)this, (String)"technologyType").orElse((Object)"java");
    }

    @Nullable
    default public String group() {
        return this.get(this.prefix() + ".group");
    }

    default public DynatraceApiVersion apiVersion() {
        return (DynatraceApiVersion)((Object)PropertyValidator.getEnum((MeterRegistryConfig)this, DynatraceApiVersion.class, (String)"apiVersion").orElse((Object)(this.deviceId().isEmpty() ? DynatraceApiVersion.V2 : DynatraceApiVersion.V1)));
    }

    default public String metricKeyPrefix() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"metricKeyPrefix").orElse((Object)"");
    }

    default public Map<String, String> defaultDimensions() {
        return Collections.emptyMap();
    }

    default public boolean enrichWithDynatraceMetadata() {
        return (Boolean)PropertyValidator.getBoolean((MeterRegistryConfig)this, (String)"enrichWithDynatraceMetadata").orElse((Object)true);
    }

    default public boolean useDynatraceSummaryInstruments() {
        if (this.apiVersion() == DynatraceApiVersion.V1) {
            return false;
        }
        return (Boolean)PropertyValidator.getBoolean((MeterRegistryConfig)this, (String)"useDynatraceSummaryInstruments").orElse((Object)true);
    }

    default public Validated<?> validate() {
        return MeterRegistryConfigValidator.checkAll((MeterRegistryConfig)this, (Function[])new Function[]{config -> StepRegistryConfig.validate((StepRegistryConfig)config), MeterRegistryConfigValidator.checkRequired((String)"apiVersion", DynatraceConfig::apiVersion).andThen(apiVersionValidation -> {
            if (apiVersionValidation.isValid()) {
                return MeterRegistryConfigValidator.checkAll((MeterRegistryConfig)this, (Function[])new Function[]{config -> {
                    if (config.apiVersion() == DynatraceApiVersion.V1) {
                        return MeterRegistryConfigValidator.checkAll((MeterRegistryConfig)this, (Function[])new Function[]{MeterRegistryConfigValidator.checkRequired((String)"apiToken", DynatraceConfig::apiToken), MeterRegistryConfigValidator.checkRequired((String)"uri", DynatraceConfig::uri), MeterRegistryConfigValidator.check((String)"deviceId", DynatraceConfig::deviceId).andThen(Validated::nonBlank), MeterRegistryConfigValidator.check((String)"technologyType", DynatraceConfig::technologyType).andThen(Validated::nonBlank)});
                    }
                    return MeterRegistryConfigValidator.checkAll((MeterRegistryConfig)this, (Function[])new Function[]{MeterRegistryConfigValidator.checkRequired((String)"uri", DynatraceConfig::uri)});
                }});
            }
            return apiVersionValidation;
        })});
    }
}

