/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.dynatrace.types;

import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.dynatrace.types.DynatraceSummary;
import io.micrometer.dynatrace.types.DynatraceSummarySnapshot;
import io.micrometer.dynatrace.types.DynatraceSummarySnapshotSupport;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynatraceTimer
extends AbstractTimer
implements DynatraceSummarySnapshotSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynatraceTimer.class);
    private static final DistributionStatisticConfig NOOP_HISTOGRAM_CONFIG = DistributionStatisticConfig.builder().percentilesHistogram(Boolean.valueOf(false)).percentiles(new double[0]).serviceLevelObjectives(new double[0]).build();
    private final DynatraceSummary summary = new DynatraceSummary();

    public DynatraceTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, TimeUnit baseTimeUnit) {
        super(id, clock, distributionStatisticConfig.merge(NOOP_HISTOGRAM_CONFIG), pauseDetector, baseTimeUnit, false);
        if (distributionStatisticConfig.isPublishingPercentiles() || distributionStatisticConfig.isPublishingHistogram()) {
            LOGGER.warn("Histogram config on DistributionStatisticConfig is currently ignored. Collecting summary statistics.");
        }
    }

    @Override
    @Deprecated
    public boolean hasValues() {
        return this.summary.getCount() > 0L;
    }

    @Override
    public DynatraceSummarySnapshot takeSummarySnapshot() {
        return this.takeSummarySnapshot(this.baseTimeUnit());
    }

    @Override
    public DynatraceSummarySnapshot takeSummarySnapshot(TimeUnit unit) {
        return this.convertIfNecessary(this.summary.takeSummarySnapshot(), unit);
    }

    @Override
    public DynatraceSummarySnapshot takeSummarySnapshotAndReset() {
        return this.takeSummarySnapshotAndReset(this.baseTimeUnit());
    }

    @Override
    public DynatraceSummarySnapshot takeSummarySnapshotAndReset(TimeUnit unit) {
        return this.convertIfNecessary(this.summary.takeSummarySnapshotAndReset(), unit);
    }

    DynatraceSummarySnapshot convertIfNecessary(DynatraceSummarySnapshot snapshot, TimeUnit unit) {
        if (unit == this.baseTimeUnit()) {
            return snapshot;
        }
        return new DynatraceSummarySnapshot(unit.convert((long)snapshot.getMin(), this.baseTimeUnit()), unit.convert((long)snapshot.getMax(), this.baseTimeUnit()), unit.convert((long)snapshot.getTotal(), this.baseTimeUnit()), snapshot.getCount());
    }

    protected void recordNonNegative(long amount, TimeUnit unit) {
        long inBaseUnit = this.baseTimeUnit().convert(amount, unit);
        this.summary.recordNonNegative(inBaseUnit);
    }

    public long count() {
        return this.summary.getCount();
    }

    public double totalTime(TimeUnit unit) {
        return unit.convert((long)this.summary.getTotal(), this.baseTimeUnit());
    }

    public double max(TimeUnit unit) {
        return unit.convert((long)this.summary.getMax(), this.baseTimeUnit());
    }

    @Deprecated
    public double min(TimeUnit unit) {
        return unit.convert((long)this.summary.getMin(), this.baseTimeUnit());
    }

    public HistogramSnapshot takeSnapshot() {
        DynatraceSummarySnapshot dtSnapshot = this.takeSummarySnapshot();
        return HistogramSnapshot.empty((long)dtSnapshot.getCount(), (double)dtSnapshot.getTotal(), (double)dtSnapshot.getMax());
    }
}

