/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.dynatrace;

import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.MeterFilterReply;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.ipc.http.HttpUrlConnectionSender;
import io.micrometer.dynatrace.AbstractDynatraceExporter;
import io.micrometer.dynatrace.DynatraceApiVersion;
import io.micrometer.dynatrace.DynatraceConfig;
import io.micrometer.dynatrace.types.DynatraceDistributionSummary;
import io.micrometer.dynatrace.types.DynatraceLongTaskTimer;
import io.micrometer.dynatrace.types.DynatraceTimer;
import io.micrometer.dynatrace.v1.DynatraceExporterV1;
import io.micrometer.dynatrace.v2.DynatraceExporterV2;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class DynatraceMeterRegistry
extends StepMeterRegistry {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("dynatrace-metrics-publisher");
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DynatraceMeterRegistry.class);
    private final boolean useDynatraceSummaryInstruments;
    private final AbstractDynatraceExporter exporter;

    public DynatraceMeterRegistry(DynatraceConfig config, Clock clock) {
        this(config, clock, DEFAULT_THREAD_FACTORY, (HttpSender)new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout()));
    }

    private DynatraceMeterRegistry(DynatraceConfig config, Clock clock, ThreadFactory threadFactory, HttpSender httpClient) {
        super((StepRegistryConfig)config, clock);
        this.useDynatraceSummaryInstruments = config.useDynatraceSummaryInstruments();
        if (config.apiVersion() == DynatraceApiVersion.V2) {
            logger.info("Exporting to Dynatrace metrics API v2");
            this.exporter = new DynatraceExporterV2(config, clock, httpClient);
            this.registerMinPercentile();
        } else {
            logger.info("Exporting to Dynatrace metrics API v1");
            this.exporter = new DynatraceExporterV1(config, clock, httpClient);
        }
        this.start(threadFactory);
    }

    public static Builder builder(DynatraceConfig config) {
        return new Builder(config);
    }

    protected void publish() {
        this.exporter.export(this.getMeters());
    }

    protected TimeUnit getBaseTimeUnit() {
        return this.exporter.getBaseTimeUnit();
    }

    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        if (this.useDynatraceSummaryInstruments) {
            return new DynatraceDistributionSummary(id, this.clock, distributionStatisticConfig, scale);
        }
        return super.newDistributionSummary(id, distributionStatisticConfig, scale);
    }

    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        if (this.useDynatraceSummaryInstruments) {
            return new DynatraceTimer(id, this.clock, distributionStatisticConfig, pauseDetector, this.exporter.getBaseTimeUnit());
        }
        return super.newTimer(id, distributionStatisticConfig, pauseDetector);
    }

    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        if (this.useDynatraceSummaryInstruments) {
            return new DynatraceLongTaskTimer(id, this.clock, this.exporter.getBaseTimeUnit(), distributionStatisticConfig, false);
        }
        return super.newLongTaskTimer(id, distributionStatisticConfig);
    }

    private void registerMinPercentile() {
        this.config().meterFilter(new MeterFilter(){
            private final Set<String> metersWithArtificialZeroPercentile = ConcurrentHashMap.newKeySet();

            public DistributionStatisticConfig configure(Meter.Id id, DistributionStatisticConfig config) {
                double[] percentiles;
                if (DynatraceMeterRegistry.this.useDynatraceSummaryInstruments && DynatraceMeterRegistry.this.dynatraceInstrumentTypeExists(id)) {
                    return config;
                }
                double[] configPercentiles = config.getPercentiles();
                if (configPercentiles == null) {
                    percentiles = new double[]{0.0};
                    this.metersWithArtificialZeroPercentile.add(id.getName() + ".percentile");
                } else if (!this.containsZeroPercentile(config)) {
                    percentiles = new double[configPercentiles.length + 1];
                    System.arraycopy(configPercentiles, 0, percentiles, 0, configPercentiles.length);
                    percentiles[configPercentiles.length] = 0.0;
                    this.metersWithArtificialZeroPercentile.add(id.getName() + ".percentile");
                } else {
                    percentiles = configPercentiles;
                }
                return DistributionStatisticConfig.builder().percentiles(percentiles).build().merge(config);
            }

            public MeterFilterReply accept(Meter.Id id) {
                return this.hasArtificialZerothPercentile(id) ? MeterFilterReply.DENY : MeterFilterReply.NEUTRAL;
            }

            private boolean containsZeroPercentile(DistributionStatisticConfig config) {
                return Arrays.stream(config.getPercentiles()).anyMatch(percentile -> percentile == 0.0);
            }

            private boolean hasArtificialZerothPercentile(Meter.Id id) {
                return this.metersWithArtificialZeroPercentile.contains(id.getName()) && "0".equals(id.getTag("phi"));
            }
        });
    }

    private boolean dynatraceInstrumentTypeExists(Meter.Id id) {
        switch (id.getType()) {
            case DISTRIBUTION_SUMMARY: 
            case TIMER: 
            case LONG_TASK_TIMER: {
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ ThreadFactory access$200() {
        return DEFAULT_THREAD_FACTORY;
    }

    public static class Builder {
        private final DynatraceConfig config;
        private Clock clock = Clock.SYSTEM;
        private ThreadFactory threadFactory = DynatraceMeterRegistry.access$200();
        private HttpSender httpClient;

        Builder(DynatraceConfig config) {
            this.config = config;
            this.httpClient = new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout());
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder httpClient(HttpSender httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public DynatraceMeterRegistry build() {
            return new DynatraceMeterRegistry(this.config, this.clock, this.threadFactory, this.httpClient);
        }
    }
}

