/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.dynatrace.v2;

import com.dynatrace.metric.util.DynatraceMetricApiConstants;
import com.dynatrace.metric.util.MetricException;
import com.dynatrace.metric.util.MetricLineBuilder;
import com.dynatrace.metric.util.MetricLinePreConfiguration;
import io.micrometer.common.lang.NonNull;
import io.micrometer.common.util.StringUtils;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.common.util.internal.logging.WarnThenDebugLogger;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.ValueAtPercentile;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.dynatrace.AbstractDynatraceExporter;
import io.micrometer.dynatrace.DynatraceConfig;
import io.micrometer.dynatrace.types.DynatraceSummarySnapshot;
import io.micrometer.dynatrace.types.DynatraceSummarySnapshotSupport;
import io.micrometer.dynatrace.v2.WarnThenDebugLoggers;
import java.net.MalformedURLException;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class DynatraceExporterV2
extends AbstractDynatraceExporter {
    private static final String METER_EXCEPTION_LOG_FORMAT = "Could not serialize meter {}: {}";
    private static final Pattern EXTRACT_LINES_OK = Pattern.compile("\"linesOk\":\\s?(\\d+)");
    private static final Pattern EXTRACT_LINES_INVALID = Pattern.compile("\"linesInvalid\":\\s?(\\d+)");
    private static final Pattern IS_NULL_ERROR_RESPONSE = Pattern.compile("\"error\":\\s?null");
    private static final Map<String, String> STATIC_DIMENSIONS = Collections.singletonMap("dt.metrics.source", "micrometer");
    private static final Map<String, String> UCUM_TIME_UNIT_MAP = DynatraceExporterV2.ucumTimeUnitMap();
    private final InternalLogger logger = InternalLoggerFactory.getInstance(DynatraceExporterV2.class);
    private final WarnThenDebugLogger stackTraceLogger = new WarnThenDebugLoggers.StackTraceLogger();
    private final WarnThenDebugLogger nanGaugeLogger = new WarnThenDebugLoggers.NanGaugeLogger();
    private final WarnThenDebugLogger metadataDiscrepancyLogger = new WarnThenDebugLoggers.MetadataDiscrepancyLogger();
    private MetricLinePreConfiguration preConfiguration;
    private boolean skipExport = false;

    public DynatraceExporterV2(DynatraceConfig config, Clock clock, HttpSender httpClient) {
        super(config, clock, httpClient);
        this.logger.info("Exporting to endpoint {}", (Object)config.uri());
        try {
            MetricLinePreConfiguration.Builder preConfigBuilder = MetricLinePreConfiguration.builder().prefix(config.metricKeyPrefix()).defaultDimensions(this.enrichWithMetricsSourceDimensions(config.defaultDimensions()));
            if (config.enrichWithDynatraceMetadata()) {
                preConfigBuilder.dynatraceMetadataDimensions();
            }
            this.preConfiguration = preConfigBuilder.build();
        }
        catch (MetricException e) {
            this.logger.error("Dynatrace configuration is invalid", (Throwable)e);
            this.skipExport = true;
        }
    }

    private boolean isValidEndpoint(String uri) {
        try {
            URI.create(uri).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException ex) {
            return false;
        }
        return true;
    }

    private boolean shouldIgnoreToken(DynatraceConfig config) {
        if (config.apiToken().isEmpty()) {
            return true;
        }
        if (config.uri().equals(DynatraceMetricApiConstants.getDefaultOneAgentEndpoint())) {
            this.logger.warn("Potential misconfiguration detected: Token is provided, but the endpoint is set to the local OneAgent endpoint, thus the token will be ignored. If exporting to the cluster API endpoint is intended, its URI has to be provided explicitly.");
            return true;
        }
        return false;
    }

    private Map<String, String> enrichWithMetricsSourceDimensions(Map<String, String> defaultDimensions) {
        LinkedHashMap<String, String> orderedDimensions = new LinkedHashMap<String, String>(defaultDimensions);
        orderedDimensions.putAll(STATIC_DIMENSIONS);
        return orderedDimensions;
    }

    @Override
    public void export(@NonNull List<Meter> meters) {
        if (this.skipExport) {
            this.logger.warn("Dynatrace configuration is invalid, skipping export.");
            return;
        }
        if (meters.isEmpty()) {
            this.logger.debug("Meter list is empty, nothing to export. Did you create any meters?");
            return;
        }
        HashMap<String, String> seenMetadata = null;
        if (this.config.exportMeterMetadata()) {
            seenMetadata = new HashMap<String, String>();
        }
        int partitionSize = Math.min(this.config.batchSize(), DynatraceMetricApiConstants.getPayloadLinesLimit());
        ArrayList<String> batch = new ArrayList<String>(partitionSize);
        for (Meter meter : meters) {
            Stream<String> metricLines = this.toMetricLines(meter, seenMetadata);
            metricLines.forEach(line -> {
                batch.add((String)line);
                this.sendBatchIfFull(batch, partitionSize);
            });
        }
        if (seenMetadata != null) {
            seenMetadata.values().forEach(line -> {
                if (line != null) {
                    batch.add((String)line);
                    this.sendBatchIfFull(batch, partitionSize);
                }
            });
        }
        if (!batch.isEmpty()) {
            this.send(batch);
        }
    }

    private void sendBatchIfFull(List<String> batch, int partitionSize) {
        if (batch.size() == partitionSize) {
            this.send(batch);
            batch.clear();
        }
    }

    private Stream<String> toMetricLines(Meter meter, Map<String, String> seenMetadata) {
        return (Stream)meter.match(m -> this.toGaugeLine((Meter)m, seenMetadata), m -> this.toCounterLine((Meter)m, seenMetadata), m -> this.toTimerLine((Timer)m, seenMetadata), m -> this.toDistributionSummaryLine((DistributionSummary)m, seenMetadata), m -> this.toLongTaskTimerLine((LongTaskTimer)m, seenMetadata), m -> this.toGaugeLine((Meter)m, seenMetadata), m -> this.toCounterLine((Meter)m, seenMetadata), m -> this.toFunctionTimerLine((FunctionTimer)m, seenMetadata), m -> this.toGaugeLine((Meter)m, seenMetadata));
    }

    Stream<String> toGaugeLine(Meter meter, Map<String, String> seenMetadata) {
        return this.toMeterLine(meter, (theMeter, measurement) -> this.createGaugeLine((Meter)theMeter, seenMetadata, (Measurement)measurement));
    }

    private String createGaugeLine(Meter meter, Map<String, String> seenMetadata, Measurement measurement) {
        try {
            double value = measurement.getValue();
            if (Double.isNaN(value)) {
                this.nanGaugeLogger.log(() -> String.format("Meter '%s' returned a value of NaN, which will not be exported. This can be a deliberate value or because the weak reference to the backing object expired.", meter.getId().getName()));
                return null;
            }
            MetricLineBuilder.GaugeStep gaugeStep = this.createTypeStep(meter).gauge();
            if (this.shouldExportMetadata(meter.getId())) {
                this.storeMetadata(this.enrichMetadata(gaugeStep.metadata(), meter), seenMetadata);
            }
            return gaugeStep.value(value).timestamp(Instant.ofEpochMilli(this.clock.wallTime())).build();
        }
        catch (MetricException e) {
            this.logger.warn(METER_EXCEPTION_LOG_FORMAT, (Object)meter.getId(), (Object)e.getMessage());
            return null;
        }
    }

    Stream<String> toCounterLine(Meter counter, Map<String, String> seenMetadata) {
        return this.toMeterLine(counter, (meter, measurement) -> this.createCounterLine((Meter)meter, seenMetadata, (Measurement)measurement));
    }

    private String createCounterLine(Meter meter, Map<String, String> seenMetadata, Measurement measurement) {
        try {
            MetricLineBuilder.CounterStep counterStep = this.createTypeStep(meter).count();
            if (this.shouldExportMetadata(meter.getId())) {
                this.storeMetadata(this.enrichMetadata(counterStep.metadata(), meter), seenMetadata);
            }
            return counterStep.delta(measurement.getValue()).timestamp(Instant.ofEpochMilli(this.clock.wallTime())).build();
        }
        catch (MetricException e) {
            this.logger.warn(METER_EXCEPTION_LOG_FORMAT, (Object)meter.getId(), (Object)e.getMessage());
            return null;
        }
    }

    Stream<String> toTimerLine(Timer meter, Map<String, String> seenMetadata) {
        if (!(meter instanceof DynatraceSummarySnapshotSupport)) {
            return this.toSummaryLine((Meter)meter, seenMetadata, meter.takeSnapshot(), this.getBaseTimeUnit());
        }
        DynatraceSummarySnapshot snapshot = ((DynatraceSummarySnapshotSupport)meter).takeSummarySnapshotAndReset(this.getBaseTimeUnit());
        if (snapshot.getCount() == 0L) {
            return Stream.empty();
        }
        return this.createSummaryLine((Meter)meter, seenMetadata, snapshot.getMin(), snapshot.getMax(), snapshot.getTotal(), snapshot.getCount());
    }

    private Stream<String> toSummaryLine(Meter meter, Map<String, String> seenMetadata, HistogramSnapshot histogramSnapshot, TimeUnit timeUnit) {
        long count = histogramSnapshot.count();
        if (count < 1L) {
            this.logger.debug("Summary with 0 count dropped: {}", (Object)meter.getId().getName());
            return Stream.empty();
        }
        double total = timeUnit != null ? histogramSnapshot.total(timeUnit) : histogramSnapshot.total();
        double max = timeUnit != null ? histogramSnapshot.max(timeUnit) : histogramSnapshot.max();
        double min = count == 1L ? max : this.minFromHistogramSnapshot(histogramSnapshot, timeUnit);
        return this.createSummaryLine(meter, seenMetadata, min, max, total, count);
    }

    private double minFromHistogramSnapshot(HistogramSnapshot histogramSnapshot, TimeUnit timeUnit) {
        ValueAtPercentile[] valuesAtPercentiles;
        for (ValueAtPercentile valueAtPercentile : valuesAtPercentiles = histogramSnapshot.percentileValues()) {
            if (valueAtPercentile.percentile() != 0.0) continue;
            return timeUnit != null ? valueAtPercentile.value(timeUnit) : valueAtPercentile.value();
        }
        return Double.NaN;
    }

    private Stream<String> createSummaryLine(Meter meter, Map<String, String> seenMetadata, double min, double max, double total, long count) {
        try {
            MetricLineBuilder.GaugeStep gaugeStep = this.createTypeStep(meter).gauge();
            if (this.shouldExportMetadata(meter.getId())) {
                this.storeMetadata(this.enrichMetadata(gaugeStep.metadata(), meter), seenMetadata);
            }
            return Stream.of(gaugeStep.summary(min, max, total, count).timestamp(Instant.ofEpochMilli(this.clock.wallTime())).build());
        }
        catch (MetricException e) {
            this.logger.warn(METER_EXCEPTION_LOG_FORMAT, (Object)meter.getId(), (Object)e.getMessage());
            return Stream.empty();
        }
    }

    Stream<String> toDistributionSummaryLine(DistributionSummary meter, Map<String, String> seenMetadata) {
        if (!(meter instanceof DynatraceSummarySnapshotSupport)) {
            return this.toSummaryLine((Meter)meter, seenMetadata, meter.takeSnapshot(), null);
        }
        DynatraceSummarySnapshot snapshot = ((DynatraceSummarySnapshotSupport)meter).takeSummarySnapshotAndReset();
        if (snapshot.getCount() == 0L) {
            return Stream.empty();
        }
        return this.createSummaryLine((Meter)meter, seenMetadata, snapshot.getMin(), snapshot.getMax(), snapshot.getTotal(), snapshot.getCount());
    }

    Stream<String> toLongTaskTimerLine(LongTaskTimer meter, Map<String, String> seenMetadata) {
        if (meter instanceof DynatraceSummarySnapshotSupport) {
            DynatraceSummarySnapshot snapshot = ((DynatraceSummarySnapshotSupport)meter).takeSummarySnapshot(this.getBaseTimeUnit());
            if (snapshot.getCount() == 0L) {
                return Stream.empty();
            }
            return this.createSummaryLine((Meter)meter, seenMetadata, snapshot.getMin(), snapshot.getMax(), snapshot.getTotal(), snapshot.getCount());
        }
        HistogramSnapshot snapshot = meter.takeSnapshot();
        long count = snapshot.count();
        if (count == 0L) {
            this.logger.debug("Timer with 0 count dropped: {}", (Object)meter.getId().getName());
            return Stream.empty();
        }
        if (count == 1L) {
            double total = snapshot.total(this.getBaseTimeUnit());
            return this.createSummaryLine((Meter)meter, seenMetadata, total, total, total, count);
        }
        return this.toSummaryLine((Meter)meter, seenMetadata, snapshot, this.getBaseTimeUnit());
    }

    Stream<String> toFunctionTimerLine(FunctionTimer meter, Map<String, String> seenMetadata) {
        long count = (long)meter.count();
        if (count == 0L) {
            this.logger.debug("Timer with 0 count dropped: {}", (Object)meter.getId().getName());
            return Stream.empty();
        }
        double total = meter.totalTime(this.getBaseTimeUnit());
        if (count == 1L) {
            return this.createSummaryLine((Meter)meter, seenMetadata, total, total, total, count);
        }
        double average = total / (double)count;
        return this.createSummaryLine((Meter)meter, seenMetadata, average, average, total, count);
    }

    private Stream<String> toMeterLine(Meter meter, BiFunction<Meter, Measurement, String> measurementConverter) {
        return this.streamOf(meter.measure()).map(measurement -> (String)measurementConverter.apply(meter, (Measurement)measurement)).filter(Objects::nonNull);
    }

    private MetricLineBuilder.TypeStep createTypeStep(Meter meter) throws MetricException {
        MetricLineBuilder.TypeStep typeStep = MetricLineBuilder.create((MetricLinePreConfiguration)this.preConfiguration).metricKey(meter.getId().getName());
        for (Tag tag : meter.getId().getTagsAsIterable()) {
            typeStep.dimension(tag.getKey(), tag.getValue());
        }
        return typeStep;
    }

    private <T> Stream<T> streamOf(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    private void send(List<String> metricLines) {
        String endpoint = this.config.uri();
        if (!this.isValidEndpoint(endpoint)) {
            this.logger.warn("Invalid endpoint, skipping export... ({})", (Object)endpoint);
            return;
        }
        try {
            int lineCount = metricLines.size();
            this.logger.debug("Sending {} lines to {}", (Object)lineCount, (Object)endpoint);
            String body = String.join((CharSequence)"\n", metricLines);
            this.logger.debug("Sending lines:\n{}", (Object)body);
            HttpSender.Request.Builder requestBuilder = this.httpClient.post(endpoint);
            if (!this.shouldIgnoreToken(this.config)) {
                requestBuilder.withHeader("Authorization", "Api-Token " + this.config.apiToken());
            }
            requestBuilder.withHeader("User-Agent", "micrometer").withPlainText(body).send().onSuccess(response -> this.handleSuccess(lineCount, (HttpSender.Response)response)).onError(response -> this.logger.error("Failed metric ingestion: Error Code={}, Response Body={}", (Object)response.code(), (Object)this.getTruncatedBody((HttpSender.Response)response)));
        }
        catch (Throwable throwable) {
            this.logger.warn("Failed metric ingestion: {}", (Object)throwable.toString());
            this.stackTraceLogger.log(String.format("Stack trace for previous 'Failed metric ingestion' warning log: %s", throwable.getMessage()), throwable);
        }
    }

    private String getTruncatedBody(HttpSender.Response response) {
        return StringUtils.truncate((String)response.body(), (int)1000, (String)" (truncated)");
    }

    private void handleSuccess(int totalSent, HttpSender.Response response) {
        if (response.code() == 202) {
            if (IS_NULL_ERROR_RESPONSE.matcher(response.body()).find()) {
                Matcher linesOkMatchResult = EXTRACT_LINES_OK.matcher(response.body());
                Matcher linesInvalidMatchResult = EXTRACT_LINES_INVALID.matcher(response.body());
                if (linesOkMatchResult.find() && linesInvalidMatchResult.find()) {
                    this.logger.debug("Sent {} metric lines, linesOk: {}, linesInvalid: {}.", new Object[]{totalSent, linesOkMatchResult.group(1), linesInvalidMatchResult.group(1)});
                } else {
                    this.logger.warn("Unable to parse response: {}", (Object)this.getTruncatedBody(response));
                }
            } else {
                this.logger.warn("Unable to parse response: {}", (Object)this.getTruncatedBody(response));
            }
        } else {
            this.logger.error("Expected status code 202, got {}.\nResponse Body={}\nDid you specify the ingest path (e.g.: /api/v2/metrics/ingest)?", (Object)response.code(), (Object)this.getTruncatedBody(response));
        }
    }

    private boolean shouldExportMetadata(Meter.Id id) {
        return this.config.exportMeterMetadata() && (!StringUtils.isEmpty((String)id.getBaseUnit()) || !StringUtils.isEmpty((String)id.getDescription()));
    }

    private MetricLineBuilder.MetadataStep enrichMetadata(MetricLineBuilder.MetadataStep metadataStep, Meter meter) {
        return metadataStep.description(meter.getId().getDescription()).unit(DynatraceExporterV2.mapUnitIfNeeded(meter.getId().getBaseUnit()));
    }

    private void storeMetadata(MetricLineBuilder.MetadataStep metadataStep, Map<String, String> seenMetadata) {
        if (seenMetadata == null || metadataStep == null) {
            return;
        }
        String metadataLine = metadataStep.build();
        if (metadataLine == null) {
            return;
        }
        String key = this.extractMetricKey(metadataLine);
        if (!seenMetadata.containsKey(key)) {
            seenMetadata.put(key, metadataLine);
        } else {
            String previousMetadataLine = seenMetadata.get(key);
            if (previousMetadataLine != null && !previousMetadataLine.equals(metadataLine)) {
                seenMetadata.put(key, null);
                this.metadataDiscrepancyLogger.log(() -> String.format("Metadata discrepancy detected:\noriginal metadata:\t%s\ntried to set new:\t%s\nMetadata for metric key %s will not be sent.", previousMetadataLine, metadataLine, key));
            }
        }
    }

    private String extractMetricKey(String metadataLine) {
        char c;
        if (metadataLine == null) {
            return null;
        }
        StringBuilder metricKey = new StringBuilder(32);
        for (int i = 1; i < metadataLine.length() && (c = metadataLine.charAt(i)) != ' ' && c != ','; ++i) {
            metricKey.append(c);
        }
        return metricKey.toString();
    }

    private static String mapUnitIfNeeded(String unit) {
        return unit != null ? UCUM_TIME_UNIT_MAP.getOrDefault(unit.toLowerCase(Locale.ROOT), unit) : null;
    }

    private static Map<String, String> ucumTimeUnitMap() {
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put(TimeUnit.NANOSECONDS.toString().toLowerCase(Locale.ROOT), "ns");
        mapping.put("nanoseconds", "ns");
        mapping.put("nanosecond", "ns");
        mapping.put(TimeUnit.MICROSECONDS.toString().toLowerCase(Locale.ROOT), "us");
        mapping.put("microseconds", "us");
        mapping.put("microsecond", "us");
        mapping.put(TimeUnit.MILLISECONDS.toString().toLowerCase(Locale.ROOT), "ms");
        mapping.put("milliseconds", "ms");
        mapping.put("millisecond", "ms");
        mapping.put(TimeUnit.SECONDS.toString().toLowerCase(Locale.ROOT), "s");
        mapping.put("seconds", "s");
        mapping.put("second", "s");
        mapping.put(TimeUnit.MINUTES.toString().toLowerCase(Locale.ROOT), "min");
        mapping.put("minutes", "min");
        mapping.put("minute", "min");
        mapping.put(TimeUnit.HOURS.toString().toLowerCase(Locale.ROOT), "h");
        mapping.put("hours", "h");
        mapping.put("hour", "h");
        return Collections.unmodifiableMap(mapping);
    }
}

