/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.dynatrace.v1;

import io.micrometer.common.util.StringUtils;
import io.micrometer.common.util.internal.logging.WarnThenDebugLogger;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

public class DynatraceNamingConventionV1
implements NamingConvention {
    private static final WarnThenDebugLogger logger = new WarnThenDebugLogger(DynatraceNamingConventionV1.class);
    private static final Pattern NAME_CLEANUP_PATTERN = Pattern.compile("[^\\w._-]");
    private static final Pattern LEADING_NUMERIC_PATTERN = Pattern.compile("[._-]([\\d])+");
    private static final Pattern KEY_CLEANUP_PATTERN = Pattern.compile("[^\\w.-]");
    private static final int TAG_VALUE_MAX_LENGTH = 128;
    private final NamingConvention delegate;

    public DynatraceNamingConventionV1(NamingConvention delegate) {
        this.delegate = delegate;
    }

    public DynatraceNamingConventionV1() {
        this(NamingConvention.dot);
    }

    public String name(String name, Meter.Type type, @Nullable String baseUnit) {
        return "custom:" + this.sanitizeName(this.delegate.name(name, type, baseUnit));
    }

    private String sanitizeName(String name) {
        if (name.equals("system.load.average.1m")) {
            return "system.load.average.oneminute";
        }
        String sanitized = NAME_CLEANUP_PATTERN.matcher(name).replaceAll("_");
        if (LEADING_NUMERIC_PATTERN.matcher(sanitized).find()) {
            logger.log(() -> "'" + sanitized + "' (original name: '" + name + "') is not a valid meter name. Dynatrace doesn't allow leading numeric characters after non-alphabets. Please rename it to conform to the constraints. If it comes from a third party, please use MeterFilter to rename it.");
        }
        return sanitized;
    }

    public String tagKey(String key) {
        return KEY_CLEANUP_PATTERN.matcher(this.delegate.tagKey(key)).replaceAll("_");
    }

    public String tagValue(String value) {
        return StringUtils.truncate((String)value, (int)128);
    }
}

