/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.dynatrace;

import io.micrometer.core.instrument.config.MeterRegistryConfig;
import io.micrometer.core.instrument.config.MeterRegistryConfigValidator;
import io.micrometer.core.instrument.config.validate.PropertyValidator;
import io.micrometer.core.instrument.config.validate.Validated;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.StringUtils;
import io.micrometer.core.lang.Nullable;
import java.util.function.Function;

public interface DynatraceConfig
extends StepRegistryConfig {
    default public String prefix() {
        return "dynatrace";
    }

    default public String apiToken() {
        return (String)PropertyValidator.getSecret((MeterRegistryConfig)this, (String)"apiToken").required().get();
    }

    default public String uri() {
        return (String)PropertyValidator.getUrlString((MeterRegistryConfig)this, (String)"uri").required().get();
    }

    default public String deviceId() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"deviceId").required().get();
    }

    default public String technologyType() {
        return (String)PropertyValidator.getSecret((MeterRegistryConfig)this, (String)"technologyType").map(v -> StringUtils.isEmpty((String)v) ? "java" : v).get();
    }

    @Nullable
    default public String group() {
        return this.get(this.prefix() + ".group");
    }

    default public Validated<?> validate() {
        return MeterRegistryConfigValidator.checkAll((MeterRegistryConfig)this, (Function[])new Function[]{c -> StepRegistryConfig.validate((StepRegistryConfig)c), MeterRegistryConfigValidator.checkRequired((String)"apiToken", DynatraceConfig::apiToken), MeterRegistryConfigValidator.checkRequired((String)"uri", DynatraceConfig::uri), MeterRegistryConfigValidator.checkRequired((String)"deviceId", DynatraceConfig::deviceId), MeterRegistryConfigValidator.check((String)"technologyType", DynatraceConfig::technologyType).andThen(Validated::nonBlank)});
    }
}

