/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.dynatrace.v2;

import com.dynatrace.metric.util.Dimension;
import com.dynatrace.metric.util.DimensionList;
import com.dynatrace.metric.util.DynatraceMetricApiConstants;
import com.dynatrace.metric.util.Metric;
import com.dynatrace.metric.util.MetricBuilderFactory;
import com.dynatrace.metric.util.MetricException;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.ValueAtPercentile;
import io.micrometer.core.instrument.util.AbstractPartition;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.util.internal.logging.InternalLogger;
import io.micrometer.core.util.internal.logging.InternalLoggerFactory;
import io.micrometer.dynatrace.AbstractDynatraceExporter;
import io.micrometer.dynatrace.DynatraceConfig;
import java.net.MalformedURLException;
import java.net.URI;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class DynatraceExporterV2
extends AbstractDynatraceExporter {
    private static final String METER_EXCEPTION_LOG_FORMAT = "Could not serialize meter {}: {}";
    private static final Pattern EXTRACT_LINES_OK = Pattern.compile("\"linesOk\":\\s?(\\d+)");
    private static final Pattern EXTRACT_LINES_INVALID = Pattern.compile("\"linesInvalid\":\\s?(\\d+)");
    private static final Pattern IS_NULL_ERROR_RESPONSE = Pattern.compile("\"error\":\\s?null");
    private final InternalLogger logger = InternalLoggerFactory.getInstance(DynatraceExporterV2.class);
    private static final Map<String, String> staticDimensions = Collections.singletonMap("dt.metrics.source", "micrometer");
    private final String endpoint;
    private final boolean ignoreToken;
    private final MetricBuilderFactory metricBuilderFactory;

    public DynatraceExporterV2(DynatraceConfig config, Clock clock, HttpSender httpClient) {
        super(config, clock, httpClient);
        this.endpoint = config.uri();
        this.showErrorIfEndpointIsInvalid(this.endpoint);
        this.ignoreToken = this.shouldIgnoreToken(config);
        this.logger.info("Exporting to endpoint {}", (Object)this.endpoint);
        MetricBuilderFactory.MetricBuilderFactoryBuilder factoryBuilder = MetricBuilderFactory.builder().withPrefix(config.metricKeyPrefix()).withDefaultDimensions(this.parseDefaultDimensions(config.defaultDimensions()));
        if (config.enrichWithDynatraceMetadata()) {
            factoryBuilder.withDynatraceMetadata();
        }
        this.metricBuilderFactory = factoryBuilder.build();
    }

    private void showErrorIfEndpointIsInvalid(String uri) {
        try {
            URI.create(uri).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException ex) {
            this.logger.error("Invalid URI provided, exporting will fail: {}", (Object)uri);
        }
    }

    private boolean shouldIgnoreToken(DynatraceConfig config) {
        if (config.apiToken().isEmpty()) {
            return true;
        }
        if (config.uri().equals(DynatraceMetricApiConstants.getDefaultOneAgentEndpoint())) {
            this.logger.warn("Potential misconfiguration detected: Token is provided, but the endpoint is set to the local OneAgent endpoint, thus the token will be ignored. If exporting to the cluster API endpoint is intended, its URI has to be provided explicitly.");
            return true;
        }
        return false;
    }

    private DimensionList parseDefaultDimensions(Map<String, String> defaultDimensions) {
        List dimensions = Stream.concat(defaultDimensions.entrySet().stream(), staticDimensions.entrySet().stream()).map(entry -> Dimension.create((String)((String)entry.getKey()), (String)((String)entry.getValue()))).collect(Collectors.toList());
        return DimensionList.fromCollection(dimensions);
    }

    @Override
    public void export(List<Meter> meters) {
        List<String> metricLines = meters.stream().flatMap(this::toMetricLines).collect(Collectors.toList());
        this.sendInBatches(metricLines);
    }

    private Stream<String> toMetricLines(Meter meter) {
        return (Stream)meter.match(this::toGaugeLine, this::toCounterLine, this::toTimerLine, this::toDistributionSummaryLine, this::toLongTaskTimerLine, this::toTimeGaugeLine, this::toFunctionCounterLine, this::toFunctionTimerLine, this::toMeterLine);
    }

    Stream<String> toGaugeLine(Gauge meter) {
        return this.toMeterLine((Meter)meter, this::createGaugeLine);
    }

    private String createGaugeLine(Meter meter, Measurement measurement) {
        try {
            return this.createMetricBuilder(meter).setDoubleGaugeValue(measurement.getValue()).serialize();
        }
        catch (MetricException e) {
            this.logger.warn(METER_EXCEPTION_LOG_FORMAT, (Object)meter.getId().getName(), (Object)e.getMessage());
            return null;
        }
    }

    Stream<String> toCounterLine(Counter meter) {
        return this.toMeterLine((Meter)meter, this::createCounterLine);
    }

    private String createCounterLine(Meter meter, Measurement measurement) {
        try {
            return this.createMetricBuilder(meter).setDoubleCounterValueDelta(measurement.getValue()).serialize();
        }
        catch (MetricException e) {
            this.logger.warn(METER_EXCEPTION_LOG_FORMAT, (Object)meter.getId().getName(), (Object)e.getMessage());
            return null;
        }
    }

    Stream<String> toTimerLine(Timer meter) {
        return this.toSummaryLine((Meter)meter, meter.takeSnapshot(), this.getBaseTimeUnit());
    }

    private Stream<String> toSummaryLine(Meter meter, HistogramSnapshot histogramSnapshot, TimeUnit timeUnit) {
        long count = histogramSnapshot.count();
        if (count < 1L) {
            this.logger.debug("Summary with 0 count dropped: {}", (Object)meter.getId().getName());
            return Stream.empty();
        }
        double total = timeUnit != null ? histogramSnapshot.total(timeUnit) : histogramSnapshot.total();
        double max = timeUnit != null ? histogramSnapshot.max(timeUnit) : histogramSnapshot.max();
        double min = count == 1L ? max : this.minFromHistogramSnapshot(histogramSnapshot, timeUnit);
        return this.createSummaryLine(meter, min, max, total, count);
    }

    private double minFromHistogramSnapshot(HistogramSnapshot histogramSnapshot, TimeUnit timeUnit) {
        ValueAtPercentile[] valuesAtPercentiles;
        for (ValueAtPercentile valueAtPercentile : valuesAtPercentiles = histogramSnapshot.percentileValues()) {
            if (valueAtPercentile.percentile() != 0.0) continue;
            return timeUnit != null ? valueAtPercentile.value(timeUnit) : valueAtPercentile.value();
        }
        return Double.NaN;
    }

    private Stream<String> createSummaryLine(Meter meter, double min, double max, double total, long count) {
        try {
            String line = this.createMetricBuilder(meter).setDoubleSummaryValue(min, max, total, count).serialize();
            return Stream.of(line);
        }
        catch (MetricException e) {
            this.logger.warn(METER_EXCEPTION_LOG_FORMAT, (Object)meter.getId().getName(), (Object)e.getMessage());
            return Stream.empty();
        }
    }

    Stream<String> toDistributionSummaryLine(DistributionSummary meter) {
        return this.toSummaryLine((Meter)meter, meter.takeSnapshot(), null);
    }

    Stream<String> toLongTaskTimerLine(LongTaskTimer meter) {
        return this.toSummaryLine((Meter)meter, meter.takeSnapshot(), this.getBaseTimeUnit());
    }

    Stream<String> toTimeGaugeLine(TimeGauge meter) {
        return this.toMeterLine((Meter)meter, this::createGaugeLine);
    }

    Stream<String> toFunctionCounterLine(FunctionCounter meter) {
        return this.toMeterLine((Meter)meter, this::createCounterLine);
    }

    Stream<String> toFunctionTimerLine(FunctionTimer meter) {
        long count = (long)meter.count();
        if (count < 1L) {
            this.logger.debug("Timer with 0 count dropped: {}", (Object)meter.getId().getName());
            return Stream.empty();
        }
        double total = meter.totalTime(this.getBaseTimeUnit());
        double average = meter.mean(this.getBaseTimeUnit());
        return this.createSummaryLine((Meter)meter, average, average, total, count);
    }

    Stream<String> toMeterLine(Meter meter) {
        return this.toMeterLine(meter, this::createGaugeLine);
    }

    private Stream<String> toMeterLine(Meter meter, BiFunction<Meter, Measurement, String> measurementConverter) {
        return this.streamOf(meter.measure()).map(measurement -> (String)measurementConverter.apply(meter, (Measurement)measurement)).filter(Objects::nonNull);
    }

    private Metric.Builder createMetricBuilder(Meter meter) {
        return this.metricBuilderFactory.newMetricBuilder(meter.getId().getName()).setDimensions(this.fromTags(meter.getId().getTags())).setTimestamp(Instant.ofEpochMilli(this.clock.wallTime()));
    }

    private DimensionList fromTags(List<Tag> tags) {
        return DimensionList.fromCollection((Collection)tags.stream().map(tag -> Dimension.create((String)tag.getKey(), (String)tag.getValue())).collect(Collectors.toList()));
    }

    private <T> Stream<T> streamOf(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    private void send(List<String> metricLines) {
        try {
            String body = String.join((CharSequence)"\n", metricLines);
            this.logger.debug("Sending lines:\n{}", (Object)body);
            HttpSender.Request.Builder requestBuilder = this.httpClient.post(this.endpoint);
            if (!this.ignoreToken) {
                requestBuilder.withHeader("Authorization", "Api-Token " + this.config.apiToken());
            }
            requestBuilder.withHeader("User-Agent", "micrometer").withPlainText(body).send().onSuccess(response -> this.handleSuccess(metricLines.size(), (HttpSender.Response)response)).onError(response -> this.logger.error("Failed metric ingestion: Error Code={}, Response Body={}", (Object)response.code(), (Object)response.body()));
        }
        catch (Throwable throwable) {
            this.logger.error("Failed metric ingestion: " + throwable.getMessage(), throwable);
        }
    }

    private void handleSuccess(int totalSent, HttpSender.Response response) {
        if (response.code() == 202) {
            if (IS_NULL_ERROR_RESPONSE.matcher(response.body()).find()) {
                Matcher linesOkMatchResult = EXTRACT_LINES_OK.matcher(response.body());
                Matcher linesInvalidMatchResult = EXTRACT_LINES_INVALID.matcher(response.body());
                if (linesOkMatchResult.find() && linesInvalidMatchResult.find()) {
                    this.logger.debug("Sent {} metric lines, linesOk: {}, linesInvalid: {}.", new Object[]{totalSent, linesOkMatchResult.group(1), linesInvalidMatchResult.group(1)});
                } else {
                    this.logger.warn("Unable to parse response: {}", (Object)response.body());
                }
            } else {
                this.logger.warn("Unable to parse response: {}", (Object)response.body());
            }
        } else {
            this.logger.error("Expected status code 202, got {}.\nResponse Body={}\nDid you specify the ingest path (e.g.: /api/v2/metrics/ingest)?", (Object)response.code(), (Object)response.body());
        }
    }

    private void sendInBatches(List<String> metricLines) {
        int partitionSize = Math.min(this.config.batchSize(), DynatraceMetricApiConstants.getPayloadLinesLimit());
        MetricLinePartition.partition(metricLines, partitionSize).forEach(this::send);
    }

    static class MetricLinePartition
    extends AbstractPartition<String> {
        private MetricLinePartition(List<String> list, int partitionSize) {
            super(list, partitionSize);
        }

        static List<List<String>> partition(List<String> list, int partitionSize) {
            return new MetricLinePartition(list, partitionSize);
        }
    }
}

