/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.elastic;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.MeterPartition;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.core.instrument.util.StringEscapeUtils;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.ipc.http.HttpUrlConnectionSender;
import io.micrometer.core.lang.NonNull;
import io.micrometer.elastic.ElasticConfig;
import io.micrometer.elastic.ElasticNamingConvention;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticMeterRegistry
extends StepMeterRegistry {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("elastic-metrics-publisher");
    static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_INSTANT;
    private static final String ES_METRICS_TEMPLATE = "/_template/metrics_template";
    private static final String INDEX_LINE = "{ \"index\" : {} }\n";
    private final Logger logger = LoggerFactory.getLogger(ElasticMeterRegistry.class);
    private final ElasticConfig config;
    private final HttpSender httpClient;
    private boolean checkedForIndexTemplate = false;

    public ElasticMeterRegistry(ElasticConfig config, Clock clock) {
        this(config, clock, DEFAULT_THREAD_FACTORY, (HttpSender)new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout()));
    }

    private ElasticMeterRegistry(ElasticConfig config, Clock clock, ThreadFactory threadFactory, HttpSender httpClient) {
        super((StepRegistryConfig)config, clock);
        this.config().namingConvention((NamingConvention)new ElasticNamingConvention());
        this.config = config;
        this.httpClient = httpClient;
        this.start(threadFactory);
    }

    public static Builder builder(ElasticConfig config) {
        return new Builder(config);
    }

    public void start(ThreadFactory threadFactory) {
        if (this.config.enabled()) {
            this.logger.info("publishing metrics to elastic every " + TimeUtils.format((Duration)this.config.step()));
        }
        super.start(threadFactory);
    }

    private void createIndexIfNeeded() {
        if (this.checkedForIndexTemplate || !this.config.autoCreateIndex()) {
            return;
        }
        try {
            if (this.httpClient.head(this.config.host() + ES_METRICS_TEMPLATE).withBasicAuthentication(this.config.userName(), this.config.password()).send().onError(response -> {
                if (response.code() != 404) {
                    this.logger.error("could not create index in elastic (HTTP {})", (Object)response.code(), (Object)response.body());
                }
            }).isSuccessful()) {
                this.checkedForIndexTemplate = true;
                this.logger.debug("metrics template already exists");
                return;
            }
            this.httpClient.put(this.config.host() + ES_METRICS_TEMPLATE).withBasicAuthentication(this.config.userName(), this.config.password()).withJsonContent("{\"template\":\"metrics*\",\"mappings\":{\"_default_\":{\"_all\":{\"enabled\":false},\"properties\":{\"name\":{\"type\":\"keyword\"}}}}}").send().onError(response -> this.logger.error("failed to add metrics template to elastic", (Object)response.body()));
        }
        catch (Throwable e) {
            this.logger.error("could not create index in elastic", e);
            return;
        }
        this.checkedForIndexTemplate = true;
    }

    protected void publish() {
        this.createIndexIfNeeded();
        for (List batch : MeterPartition.partition((MeterRegistry)this, (int)this.config.batchSize())) {
            try {
                this.httpClient.post(this.config.host() + "/" + this.indexName() + "/doc/_bulk").withBasicAuthentication(this.config.userName(), this.config.password()).withJsonContent(batch.stream().map(m -> (Optional)m.match(this::writeGauge, this::writeCounter, this::writeTimer, this::writeSummary, this::writeLongTaskTimer, this::writeTimeGauge, this::writeFunctionCounter, this::writeFunctionTimer, this::writeMeter)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining("\n", "", "\n"))).send().onSuccess(response -> {
                    String body = response.body();
                    if (body.contains("\"errors\":true")) {
                        this.logger.error("failed to send metrics to elastic: {}", (Object)body);
                    } else {
                        this.logger.debug("successfully sent {} metrics to elastic", (Object)batch.size());
                    }
                }).onError(response -> this.logger.error("failed to send metrics to elastic: {}", (Object)response.body()));
            }
            catch (Throwable e) {
                this.logger.error("failed to send metrics to elastic", e);
            }
        }
    }

    private String indexName() {
        ZonedDateTime dt = ZonedDateTime.ofInstant(new Date(this.config().clock().wallTime()).toInstant(), ZoneOffset.UTC);
        return this.config.index() + "-" + DateTimeFormatter.ofPattern(this.config.indexDateFormat()).format(dt);
    }

    Optional<String> writeCounter(Counter counter) {
        return Optional.of(this.writeDocument((Meter)counter, builder -> builder.append(",\"count\":").append(counter.count())));
    }

    Optional<String> writeFunctionCounter(FunctionCounter counter) {
        return Optional.of(this.writeDocument((Meter)counter, builder -> builder.append(",\"count\":").append(counter.count())));
    }

    Optional<String> writeGauge(Gauge gauge) {
        Double value = gauge.value();
        if (!value.isNaN()) {
            return Optional.of(this.writeDocument((Meter)gauge, builder -> builder.append(",\"value\":").append(value)));
        }
        return Optional.empty();
    }

    Optional<String> writeTimeGauge(TimeGauge gauge) {
        Double value = gauge.value();
        if (!value.isNaN()) {
            return Optional.of(this.writeDocument((Meter)gauge, builder -> builder.append(",\"value\":").append(gauge.value(this.getBaseTimeUnit()))));
        }
        return Optional.empty();
    }

    Optional<String> writeFunctionTimer(FunctionTimer timer) {
        return Optional.of(this.writeDocument((Meter)timer, builder -> {
            builder.append(",\"count\":").append(timer.count());
            builder.append(",\"sum\" :").append(timer.totalTime(this.getBaseTimeUnit()));
            builder.append(",\"mean\":").append(timer.mean(this.getBaseTimeUnit()));
        }));
    }

    Optional<String> writeLongTaskTimer(LongTaskTimer timer) {
        return Optional.of(this.writeDocument((Meter)timer, builder -> {
            builder.append(",\"activeTasks\":").append(timer.activeTasks());
            builder.append(",\"duration\":").append(timer.duration(this.getBaseTimeUnit()));
        }));
    }

    Optional<String> writeTimer(Timer timer) {
        return Optional.of(this.writeDocument((Meter)timer, builder -> {
            builder.append(",\"count\":").append(timer.count());
            builder.append(",\"sum\":").append(timer.totalTime(this.getBaseTimeUnit()));
            builder.append(",\"mean\":").append(timer.mean(this.getBaseTimeUnit()));
            builder.append(",\"max\":").append(timer.max(this.getBaseTimeUnit()));
        }));
    }

    Optional<String> writeSummary(DistributionSummary summary) {
        summary.takeSnapshot();
        return Optional.of(this.writeDocument((Meter)summary, builder -> {
            builder.append(",\"count\":").append(summary.count());
            builder.append(",\"sum\":").append(summary.totalAmount());
            builder.append(",\"mean\":").append(summary.mean());
            builder.append(",\"max\":").append(summary.max());
        }));
    }

    Optional<String> writeMeter(Meter meter) {
        return Optional.of(this.writeDocument(meter, builder -> {
            for (Measurement measurement : meter.measure()) {
                builder.append(",\"").append(measurement.getStatistic().getTagValueRepresentation()).append("\":\"").append(measurement.getValue()).append("\"");
            }
        }));
    }

    String writeDocument(Meter meter, Consumer<StringBuilder> consumer) {
        StringBuilder sb = new StringBuilder(INDEX_LINE);
        String timestamp = FORMATTER.format(Instant.ofEpochMilli(this.config().clock().wallTime()));
        String name = this.getConventionName(meter.getId());
        String type = meter.getId().getType().toString().toLowerCase();
        sb.append("{\"").append(this.config.timestampFieldName()).append("\":\"").append(timestamp).append('\"').append(",\"name\":\"").append(StringEscapeUtils.escapeJson((String)name)).append('\"').append(",\"type\":\"").append(type).append('\"');
        List tags = this.getConventionTags(meter.getId());
        for (Tag tag : tags) {
            sb.append(",\"").append(StringEscapeUtils.escapeJson((String)tag.getKey())).append("\":\"").append(StringEscapeUtils.escapeJson((String)tag.getValue())).append('\"');
        }
        consumer.accept(sb);
        sb.append("}");
        return sb.toString();
    }

    @NonNull
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    static /* synthetic */ ThreadFactory access$000() {
        return DEFAULT_THREAD_FACTORY;
    }

    public static class Builder {
        private final ElasticConfig config;
        private Clock clock = Clock.SYSTEM;
        private ThreadFactory threadFactory = ElasticMeterRegistry.access$000();
        private HttpSender httpClient;

        Builder(ElasticConfig config) {
            this.config = config;
            this.httpClient = new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout());
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder httpClient(HttpSender httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public ElasticMeterRegistry build() {
            return new ElasticMeterRegistry(this.config, this.clock, this.threadFactory, this.httpClient);
        }
    }
}

