/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.graphite;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;

public class GraphiteHierarchicalNameMapper
implements HierarchicalNameMapper {
    private final String[] tagsAsPrefix;

    public GraphiteHierarchicalNameMapper(String ... tagsAsPrefix) {
        this.tagsAsPrefix = tagsAsPrefix;
    }

    public String toHierarchicalName(Meter.Id id, NamingConvention convention) {
        StringBuilder prefix = new StringBuilder();
        StringBuilder tags = new StringBuilder();
        if (id.getTags().iterator().hasNext()) {
            block0: for (Tag tag : id.getConventionTags(convention)) {
                for (String tagPrefix : this.tagsAsPrefix) {
                    if (!tag.getKey().equals(tagPrefix)) continue;
                    prefix.append(tag.getValue()).append(".");
                    continue block0;
                }
                tags.append(("." + tag.getKey() + "." + tag.getValue()).replace(" ", "_"));
            }
        }
        return prefix.toString() + id.getConventionName(convention) + tags;
    }
}

