/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.graphite;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.lang.Nullable;
import java.text.Normalizer;
import java.util.regex.Pattern;

public class GraphiteNamingConvention
implements NamingConvention {
    private final NamingConvention delegate;
    private static final Pattern blacklistedChars = Pattern.compile("[{}(),=\\[\\]/]");

    public GraphiteNamingConvention() {
        this(NamingConvention.camelCase);
    }

    public GraphiteNamingConvention(NamingConvention delegate) {
        this.delegate = delegate;
    }

    public String name(String name, Meter.Type type, @Nullable String baseUnit) {
        return this.format(name);
    }

    public String tagKey(String key) {
        return this.format(key);
    }

    public String tagValue(String value) {
        return this.format(value);
    }

    private String format(String name) {
        String sanitized = Normalizer.normalize(name, Normalizer.Form.NFKD);
        sanitized = this.delegate.tagKey(sanitized);
        return blacklistedChars.matcher(sanitized).replaceAll("_");
    }
}

