/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.humio;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.DoubleFormat;
import io.micrometer.core.instrument.util.MeterPartition;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.core.instrument.util.StringEscapeUtils;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.ipc.http.HttpUrlConnectionSender;
import io.micrometer.core.lang.NonNull;
import io.micrometer.core.lang.Nullable;
import io.micrometer.humio.HumioConfig;
import io.micrometer.humio.HumioNamingConvention;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HumioMeterRegistry
extends StepMeterRegistry {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("humio-metrics-publisher");
    private final Logger logger = LoggerFactory.getLogger(HumioMeterRegistry.class);
    private final HumioConfig config;
    private final HttpSender httpClient;

    public HumioMeterRegistry(HumioConfig config, Clock clock) {
        this(config, clock, DEFAULT_THREAD_FACTORY, (HttpSender)new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout()));
    }

    private HumioMeterRegistry(HumioConfig config, Clock clock, ThreadFactory threadFactory, HttpSender httpClient) {
        super((StepRegistryConfig)config, clock);
        this.config().namingConvention((NamingConvention)new HumioNamingConvention());
        this.config = config;
        this.httpClient = httpClient;
        this.start(threadFactory);
    }

    private static Attribute event(String name, double value) {
        return new Attribute(name, value);
    }

    public static Builder builder(HumioConfig config) {
        return new Builder(config);
    }

    public void start(ThreadFactory threadFactory) {
        if (this.config.enabled()) {
            this.logger.info("publishing metrics to humio every " + TimeUtils.format((Duration)this.config.step()));
        }
        super.start(threadFactory);
    }

    protected void publish() {
        for (List meters : MeterPartition.partition((MeterRegistry)this, (int)this.config.batchSize())) {
            try {
                HttpSender.Request.Builder post = this.httpClient.post(this.config.uri() + "/api/v1/ingest/humio-structured");
                String token = this.config.apiToken();
                if (token != null) {
                    post.withHeader("Authorization", "Bearer " + token);
                }
                Batch batch = new Batch(this.config().clock().wallTime());
                String tags = "";
                Map<String, String> datasourceTags = this.config.tags();
                if (datasourceTags != null && !datasourceTags.isEmpty()) {
                    tags = datasourceTags.entrySet().stream().map(tag -> "\"" + (String)tag.getKey() + "\": \"" + (String)tag.getValue() + "\"").collect(Collectors.joining(",", "\"tags\":{", "},"));
                }
                post.withJsonContent(meters.stream().map(m -> (String)m.match(batch::writeGauge, batch::writeCounter, batch::writeTimer, batch::writeSummary, batch::writeLongTaskTimer, batch::writeTimeGauge, batch::writeFunctionCounter, batch::writeFunctionTimer, batch::writeMeter)).collect(Collectors.joining(",", "[{" + tags + "\"events\": [", "]}]"))).send().onSuccess(response -> this.logger.debug("successfully sent {} metrics to humio.", (Object)meters.size())).onError(response -> this.logger.error("failed to send metrics to humio: {}", (Object)response.body()));
            }
            catch (Throwable e) {
                this.logger.warn("failed to send metrics to humio", e);
            }
        }
    }

    @NonNull
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    static /* synthetic */ ThreadFactory access$100() {
        return DEFAULT_THREAD_FACTORY;
    }

    class Batch {
        private final String timestamp;

        Batch(long wallTime) {
            this.timestamp = DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(wallTime));
        }

        String writeCounter(Counter counter) {
            return this.writeEvent((Meter)counter, HumioMeterRegistry.event("count", counter.count()));
        }

        @Nullable
        String writeFunctionCounter(FunctionCounter counter) {
            double count = counter.count();
            if (Double.isFinite(count)) {
                return this.writeEvent((Meter)counter, HumioMeterRegistry.event("count", count));
            }
            return null;
        }

        @Nullable
        String writeGauge(Gauge gauge) {
            double value = gauge.value();
            if (Double.isFinite(value)) {
                return this.writeEvent((Meter)gauge, HumioMeterRegistry.event("value", value));
            }
            return null;
        }

        @Nullable
        String writeTimeGauge(TimeGauge gauge) {
            double value = gauge.value(HumioMeterRegistry.this.getBaseTimeUnit());
            if (Double.isFinite(value)) {
                return this.writeEvent((Meter)gauge, HumioMeterRegistry.event("value", value));
            }
            return null;
        }

        String writeFunctionTimer(FunctionTimer timer) {
            return this.writeEvent((Meter)timer, HumioMeterRegistry.event("count", timer.count()), HumioMeterRegistry.event("sum", timer.totalTime(HumioMeterRegistry.this.getBaseTimeUnit())), HumioMeterRegistry.event("avg", timer.mean(HumioMeterRegistry.this.getBaseTimeUnit())));
        }

        String writeLongTaskTimer(LongTaskTimer timer) {
            return this.writeEvent((Meter)timer, HumioMeterRegistry.event(HumioMeterRegistry.this.config().namingConvention().tagKey("active.tasks"), timer.activeTasks()), HumioMeterRegistry.event("duration", timer.duration(HumioMeterRegistry.this.getBaseTimeUnit())));
        }

        String writeTimer(Timer timer) {
            HistogramSnapshot snap = timer.takeSnapshot();
            return this.writeEvent((Meter)timer, HumioMeterRegistry.event("count", snap.count()), HumioMeterRegistry.event("sum", snap.total(HumioMeterRegistry.this.getBaseTimeUnit())), HumioMeterRegistry.event("avg", snap.mean(HumioMeterRegistry.this.getBaseTimeUnit())), HumioMeterRegistry.event("max", snap.max(HumioMeterRegistry.this.getBaseTimeUnit())));
        }

        String writeSummary(DistributionSummary summary) {
            HistogramSnapshot snap = summary.takeSnapshot();
            return this.writeEvent((Meter)summary, HumioMeterRegistry.event("count", snap.count()), HumioMeterRegistry.event("sum", snap.total()), HumioMeterRegistry.event("avg", snap.mean()), HumioMeterRegistry.event("max", snap.max()));
        }

        String writeMeter(Meter meter) {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            for (Measurement measurement : meter.measure()) {
                double value = measurement.getValue();
                if (!Double.isFinite(value)) continue;
                attributes.add(HumioMeterRegistry.event(measurement.getStatistic().getTagValueRepresentation(), value));
            }
            if (attributes.isEmpty()) {
                return null;
            }
            return this.writeEvent(meter, attributes.toArray(new Attribute[0]));
        }

        String writeEvent(Meter meter, Attribute ... attributes) {
            StringBuilder sb = new StringBuilder();
            String name = HumioMeterRegistry.this.getConventionName(meter.getId());
            sb.append("{\"timestamp\":\"").append(this.timestamp).append("\",\"attributes\":{\"name\":\"").append(StringEscapeUtils.escapeJson((String)name)).append('\"');
            for (Attribute attribute : attributes) {
                sb.append(",\"").append(attribute.name).append("\":").append(DoubleFormat.decimalOrWhole((double)attribute.value));
            }
            List tags = HumioMeterRegistry.this.getConventionTags(meter.getId());
            for (Tag tag : tags) {
                String key = tag.getKey();
                for (Attribute attribute : attributes) {
                    if (!attribute.name.equals(key)) continue;
                    key = "_" + key;
                    break;
                }
                sb.append(",\"").append(StringEscapeUtils.escapeJson((String)key)).append("\":\"").append(StringEscapeUtils.escapeJson((String)tag.getValue())).append('\"');
            }
            sb.append("}}");
            return sb.toString();
        }
    }

    public static class Builder {
        private final HumioConfig config;
        private Clock clock = Clock.SYSTEM;
        private ThreadFactory threadFactory = HumioMeterRegistry.access$100();
        private HttpSender httpClient;

        Builder(HumioConfig config) {
            this.config = config;
            this.httpClient = new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout());
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder httpClient(HttpSender httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public HumioMeterRegistry build() {
            return new HumioMeterRegistry(this.config, this.clock, this.threadFactory, this.httpClient);
        }
    }

    private static class Attribute {
        private final String name;
        private final double value;

        private Attribute(String name, double value) {
            this.name = name;
            this.value = value;
        }
    }
}

