/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.influx;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.lang.Nullable;

public class InfluxNamingConvention
implements NamingConvention {
    private final NamingConvention delegate;

    public InfluxNamingConvention() {
        this(NamingConvention.snakeCase);
    }

    public InfluxNamingConvention(NamingConvention delegate) {
        this.delegate = delegate;
    }

    public String name(String name, Meter.Type type, @Nullable String baseUnit) {
        return this.format(name.replace("=", "_"));
    }

    public String tagKey(String key) {
        if (key.equals("time")) {
            throw new IllegalArgumentException("'time' is an invalid tag key in InfluxDB");
        }
        return this.format(this.delegate.tagKey(key));
    }

    public String tagValue(String value) {
        if (value.equals("time")) {
            throw new IllegalArgumentException("'time' is an invalid tag value in InfluxDB");
        }
        return this.format(value);
    }

    private String format(String name) {
        return name.replace(",", "\\,").replace(" ", "\\ ").replace("=", "\\=").replace("\"", "\\\"");
    }
}

