/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.influx;

import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.lang.Nullable;
import io.micrometer.influx.InfluxConsistency;

public interface InfluxConfig
extends StepRegistryConfig {
    public static final InfluxConfig DEFAULT = k -> null;

    default public String prefix() {
        return "influx";
    }

    default public String db() {
        String v = this.get(this.prefix() + ".db");
        return v == null ? "mydb" : v;
    }

    default public InfluxConsistency consistency() {
        String v = this.get(this.prefix() + ".consistency");
        if (v == null) {
            return InfluxConsistency.ONE;
        }
        return InfluxConsistency.valueOf(v.toUpperCase());
    }

    @Nullable
    default public String userName() {
        return this.get(this.prefix() + ".userName");
    }

    @Nullable
    default public String password() {
        return this.get(this.prefix() + ".password");
    }

    @Nullable
    default public String retentionPolicy() {
        return this.get(this.prefix() + ".retentionPolicy");
    }

    @Nullable
    default public String retentionDuration() {
        return this.get(this.prefix() + ".retentionDuration");
    }

    @Nullable
    default public Integer retentionReplicationFactor() {
        String v = this.get(this.prefix() + ".retentionReplicationFactor");
        return v == null ? null : Integer.valueOf(v);
    }

    @Nullable
    default public String retentionShardDuration() {
        return this.get(this.prefix() + ".retentionShardDuration");
    }

    default public String uri() {
        String v = this.get(this.prefix() + ".uri");
        return v == null ? "http://localhost:8086" : v;
    }

    default public boolean compressed() {
        String v = this.get(this.prefix() + ".compressed");
        return v == null || Boolean.parseBoolean(v);
    }

    default public boolean autoCreateDb() {
        String v = this.get(this.prefix() + ".autoCreateDb");
        return v == null || Boolean.parseBoolean(v);
    }
}

