/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.newrelic;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.lang.Nullable;
import io.micrometer.newrelic.NewRelicConfig;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewRelicMeterRegistry
extends StepMeterRegistry {
    private final NewRelicConfig config;
    private final Logger logger = LoggerFactory.getLogger(NewRelicMeterRegistry.class);

    public NewRelicMeterRegistry(NewRelicConfig config, Clock clock) {
        this(config, clock, Executors.defaultThreadFactory());
    }

    public NewRelicMeterRegistry(NewRelicConfig config, Clock clock, ThreadFactory threadFactory) {
        super((StepRegistryConfig)config, clock);
        this.config = config;
        Objects.requireNonNull(config.accountId());
        Objects.requireNonNull(config.apiKey());
        this.config().namingConvention(NamingConvention.camelCase);
        this.start(threadFactory);
    }

    protected void publish() {
        try {
            URL insightsEndpoint = URI.create(this.config.uri() + "/v1/accounts/" + this.config.accountId() + "/events").toURL();
            int batchSize = Math.min(this.config.batchSize(), 1000);
            List<String> events = this.getMeters().stream().flatMap(meter -> {
                if (meter instanceof Timer) {
                    return this.writeTimer((Timer)meter);
                }
                if (meter instanceof FunctionTimer) {
                    return this.writeTimer((FunctionTimer)meter);
                }
                if (meter instanceof DistributionSummary) {
                    return this.writeSummary((DistributionSummary)meter);
                }
                return this.writeMeter((Meter)meter);
            }).collect(Collectors.toList());
            if (events.size() > batchSize) {
                this.sendEvents(insightsEndpoint, events.subList(0, batchSize));
                events = new ArrayList<String>(events.subList(batchSize, events.size()));
            } else if (events.size() == batchSize) {
                this.sendEvents(insightsEndpoint, events);
                events = new ArrayList<String>();
            }
            if (!events.isEmpty()) {
                this.sendEvents(insightsEndpoint, events);
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("malformed New Relic insights endpoint -- see the 'uri' configuration", e);
        }
        catch (Throwable t) {
            this.logger.warn("failed to send metrics", t);
        }
    }

    private Stream<String> writeSummary(DistributionSummary summary) {
        Stream.Builder<String> events = Stream.builder();
        Meter.Id id = summary.getId();
        HistogramSnapshot t = summary.takeSnapshot(false);
        events.add(this.event(id, "count", t.count(), new String[0]));
        events.add(this.event(id, "sum", t.total(), new String[0]));
        events.add(this.event(id, "avg", t.mean(), new String[0]));
        events.add(this.event(id, "max", t.max(), new String[0]));
        return events.build();
    }

    private Stream<String> writeTimer(Timer timer) {
        Stream.Builder<String> events = Stream.builder();
        Meter.Id id = timer.getId();
        HistogramSnapshot t = timer.takeSnapshot(false);
        events.add(this.event(id, "count", t.count(), new String[0]));
        events.add(this.event(id, "sum", t.total(this.getBaseTimeUnit()), new String[0]));
        events.add(this.event(id, "avg", t.mean(this.getBaseTimeUnit()), new String[0]));
        events.add(this.event(id, "max", t.max(this.getBaseTimeUnit()), new String[0]));
        return events.build();
    }

    private Stream<String> writeTimer(FunctionTimer timer) {
        Stream.Builder<String> events = Stream.builder();
        Meter.Id id = timer.getId();
        events.add(this.event(id, "count", timer.count(), new String[0]));
        events.add(this.event(id, "sum", timer.count(), new String[0]));
        events.add(this.event(id, "mean", timer.mean(this.getBaseTimeUnit()), new String[0]));
        return events.build();
    }

    private Stream<String> writeMeter(Meter meter) {
        Stream.Builder<String> events = Stream.builder();
        for (Measurement measurement : meter.measure()) {
            events.add(this.event(meter.getId(), measurement.getStatistic().toString().toLowerCase(), measurement.getValue(), new String[0]));
        }
        return events.build();
    }

    private String event(Meter.Id id, String statistic, Number value, String ... additionalTags) {
        StringBuilder additionalTagsJson = new StringBuilder();
        for (int i = 0; i < additionalTags.length; i += 2) {
            additionalTagsJson.append(",\"").append(additionalTags[i]).append("\":\"").append(additionalTags[i + 1]).append("\"");
        }
        for (Tag tag : this.getConventionTags(id)) {
            additionalTagsJson.append(",\"").append(tag.getKey()).append("\":\"").append(tag.getValue()).append("\"");
        }
        return "{\"eventType\":\"" + this.getConventionName(id) + "\",\"statistic\":\"" + statistic + "\",\"value\":" + Double.toString(value.doubleValue()) + additionalTagsJson.toString() + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvents(URL insightsEndpoint, List<String> events) {
        block32: {
            HttpURLConnection con = null;
            try {
                con = (HttpURLConnection)insightsEndpoint.openConnection();
                con.setConnectTimeout((int)this.config.connectTimeout().toMillis());
                con.setReadTimeout((int)this.config.readTimeout().toMillis());
                con.setRequestMethod("POST");
                con.setRequestProperty("Content-Type", "application/json");
                con.setRequestProperty("X-Insert-Key", this.config.apiKey());
                con.setDoOutput(true);
                String body = "[" + events.stream().collect(Collectors.joining(",")) + "]";
                try (OutputStream os = con.getOutputStream();){
                    os.write(body.getBytes());
                    os.flush();
                }
                int status = con.getResponseCode();
                if (status >= 200 && status < 300) {
                    this.logger.info("successfully sent {} events to New Relic", (Object)events.size());
                    break block32;
                }
                if (status >= 400) {
                    try (InputStream in = con.getErrorStream();){
                        this.logger.error("failed to send metrics: " + new BufferedReader(new InputStreamReader(in)).lines().collect(Collectors.joining("\n")));
                        break block32;
                    }
                }
                this.logger.error("failed to send metrics: http " + status);
            }
            catch (Throwable e) {
                this.logger.warn("failed to send metrics", e);
            }
            finally {
                this.quietlyCloseUrlConnection(con);
            }
        }
    }

    private void quietlyCloseUrlConnection(@Nullable HttpURLConnection con) {
        try {
            if (con != null) {
                con.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }
}

