/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.registry.otlp;

import io.micrometer.common.lang.Nullable;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.distribution.CountAtBucket;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.HistogramSupport;
import io.micrometer.core.instrument.distribution.ValueAtPercentile;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.internal.DefaultGauge;
import io.micrometer.core.instrument.internal.DefaultMeter;
import io.micrometer.core.instrument.push.PushMeterRegistry;
import io.micrometer.core.instrument.push.PushRegistryConfig;
import io.micrometer.core.instrument.util.MeterPartition;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.ipc.http.HttpUrlConnectionSender;
import io.micrometer.registry.otlp.OtlpConfig;
import io.micrometer.registry.otlp.OtlpCounter;
import io.micrometer.registry.otlp.OtlpDistributionSummary;
import io.micrometer.registry.otlp.OtlpFunctionCounter;
import io.micrometer.registry.otlp.OtlpFunctionTimer;
import io.micrometer.registry.otlp.OtlpLongTaskTimer;
import io.micrometer.registry.otlp.OtlpTimer;
import io.micrometer.registry.otlp.StartTimeAwareMeter;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import io.opentelemetry.proto.common.v1.AnyValue;
import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.metrics.v1.AggregationTemporality;
import io.opentelemetry.proto.metrics.v1.Histogram;
import io.opentelemetry.proto.metrics.v1.HistogramDataPoint;
import io.opentelemetry.proto.metrics.v1.Metric;
import io.opentelemetry.proto.metrics.v1.NumberDataPoint;
import io.opentelemetry.proto.metrics.v1.ResourceMetrics;
import io.opentelemetry.proto.metrics.v1.ScopeMetrics;
import io.opentelemetry.proto.metrics.v1.Sum;
import io.opentelemetry.proto.metrics.v1.Summary;
import io.opentelemetry.proto.metrics.v1.SummaryDataPoint;
import io.opentelemetry.proto.resource.v1.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.DoubleSupplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;

public class OtlpMeterRegistry
extends PushMeterRegistry {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("otlp-metrics-publisher");
    private final InternalLogger logger = InternalLoggerFactory.getInstance(OtlpMeterRegistry.class);
    private final OtlpConfig config;
    private final HttpSender httpSender;
    private final Resource resource;

    public OtlpMeterRegistry() {
        this(OtlpConfig.DEFAULT, Clock.SYSTEM);
    }

    public OtlpMeterRegistry(OtlpConfig config, Clock clock) {
        this(config, clock, (HttpSender)new HttpUrlConnectionSender());
    }

    private OtlpMeterRegistry(OtlpConfig config, Clock clock, HttpSender httpSender) {
        super((PushRegistryConfig)config, clock);
        this.config = config;
        this.httpSender = httpSender;
        this.resource = Resource.newBuilder().addAllAttributes(this.getResourceAttributes()).build();
        this.config().namingConvention(NamingConvention.dot);
        this.start(DEFAULT_THREAD_FACTORY);
    }

    protected void publish() {
        for (List batch : MeterPartition.partition((MeterRegistry)this, (int)this.config.batchSize())) {
            List metrics = batch.stream().map(meter -> (Metric)meter.match(this::writeGauge, this::writeCounter, this::writeHistogramSupport, this::writeHistogramSupport, this::writeHistogramSupport, this::writeGauge, this::writeFunctionCounter, this::writeFunctionTimer, this::writeMeter)).collect(Collectors.toList());
            try {
                ExportMetricsServiceRequest request = ExportMetricsServiceRequest.newBuilder().addResourceMetrics(ResourceMetrics.newBuilder().setResource(this.resource).addScopeMetrics(ScopeMetrics.newBuilder().addAllMetrics(metrics).build()).build()).build();
                HttpSender.Response response = this.httpSender.post(this.config.url()).withContent("application/x-protobuf", request.toByteArray()).send();
                if (response.isSuccessful()) continue;
                this.logger.warn("Failed to publish metrics. Server responded with HTTP status code {} and body {}", (Object)response.code(), (Object)response.body());
            }
            catch (Throwable e) {
                this.logger.warn("Failed to publish metrics to OTLP receiver", e);
            }
        }
    }

    protected <T> Gauge newGauge(Meter.Id id, @Nullable T obj, ToDoubleFunction<T> valueFunction) {
        return new DefaultGauge(id, obj, valueFunction);
    }

    protected Counter newCounter(Meter.Id id) {
        return new OtlpCounter(id, this.clock);
    }

    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        return new OtlpTimer(id, this.clock, distributionStatisticConfig, pauseDetector, this.getBaseTimeUnit());
    }

    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        return new OtlpDistributionSummary(id, this.clock, distributionStatisticConfig, scale, true);
    }

    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        return new DefaultMeter(id, type, measurements);
    }

    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit) {
        return new OtlpFunctionTimer<T>(id, obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.getBaseTimeUnit(), this.clock);
    }

    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> countFunction) {
        return new OtlpFunctionCounter<T>(id, obj, countFunction, this.clock);
    }

    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        return new OtlpLongTaskTimer(id, this.clock, this.getBaseTimeUnit(), distributionStatisticConfig);
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().expiry(this.config.step()).build().merge(DistributionStatisticConfig.DEFAULT);
    }

    private Metric writeMeter(Meter meter) {
        return this.getMetricBuilder(meter.getId()).build();
    }

    Metric writeGauge(Gauge gauge) {
        return this.getMetricBuilder(gauge.getId()).setGauge(io.opentelemetry.proto.metrics.v1.Gauge.newBuilder().addDataPoints(NumberDataPoint.newBuilder().setTimeUnixNano(TimeUnit.MILLISECONDS.toNanos(this.clock.wallTime())).setAsDouble(gauge.value()).addAllAttributes(this.getTagsForId(gauge.getId())).build())).build();
    }

    Metric writeCounter(Counter counter) {
        return this.writeSum((StartTimeAwareMeter)counter, () -> ((Counter)counter).count());
    }

    Metric writeFunctionCounter(FunctionCounter functionCounter) {
        return this.writeSum((StartTimeAwareMeter)functionCounter, () -> ((FunctionCounter)functionCounter).count());
    }

    private Metric writeSum(StartTimeAwareMeter meter, DoubleSupplier count) {
        return this.getMetricBuilder(meter.getId()).setSum(Sum.newBuilder().addDataPoints(NumberDataPoint.newBuilder().setStartTimeUnixNano(meter.getStartTimeNanos()).setTimeUnixNano(TimeUnit.MILLISECONDS.toNanos(this.clock.wallTime())).setAsDouble(count.getAsDouble()).addAllAttributes(this.getTagsForId(meter.getId())).build()).setIsMonotonic(true).setAggregationTemporality(AggregationTemporality.AGGREGATION_TEMPORALITY_CUMULATIVE).build()).build();
    }

    Metric writeHistogramSupport(HistogramSupport histogramSupport) {
        Metric.Builder metricBuilder = this.getMetricBuilder(histogramSupport.getId());
        boolean isTimeBased = histogramSupport instanceof Timer || histogramSupport instanceof LongTaskTimer;
        HistogramSnapshot histogramSnapshot = histogramSupport.takeSnapshot();
        Iterable<? extends KeyValue> tags = this.getTagsForId(histogramSupport.getId());
        long startTimeNanos = ((StartTimeAwareMeter)histogramSupport).getStartTimeNanos();
        long wallTimeNanos = TimeUnit.MILLISECONDS.toNanos(this.clock.wallTime());
        double total = isTimeBased ? histogramSnapshot.total(this.getBaseTimeUnit()) : histogramSnapshot.total();
        long count = histogramSnapshot.count();
        if (histogramSnapshot.percentileValues().length != 0) {
            SummaryDataPoint.Builder summaryData = SummaryDataPoint.newBuilder().addAllAttributes(tags).setStartTimeUnixNano(startTimeNanos).setTimeUnixNano(wallTimeNanos).setSum(total).setCount(count);
            for (ValueAtPercentile percentile : histogramSnapshot.percentileValues()) {
                summaryData.addQuantileValues(SummaryDataPoint.ValueAtQuantile.newBuilder().setQuantile(percentile.percentile()).setValue(TimeUtils.convert((double)percentile.value(), (TimeUnit)TimeUnit.NANOSECONDS, (TimeUnit)this.getBaseTimeUnit())));
            }
            metricBuilder.setSummary(Summary.newBuilder().addDataPoints(summaryData));
            return metricBuilder.build();
        }
        HistogramDataPoint.Builder histogramDataPoint = HistogramDataPoint.newBuilder().addAllAttributes(tags).setStartTimeUnixNano(startTimeNanos).setTimeUnixNano(wallTimeNanos).setSum(total).setCount(count);
        if (histogramSnapshot.histogramCounts().length != 0) {
            for (CountAtBucket countAtBucket : histogramSnapshot.histogramCounts()) {
                histogramDataPoint.addExplicitBounds(isTimeBased ? countAtBucket.bucket(this.getBaseTimeUnit()) : countAtBucket.bucket());
                histogramDataPoint.addBucketCounts((long)countAtBucket.count());
            }
            metricBuilder.setHistogram(Histogram.newBuilder().setAggregationTemporality(AggregationTemporality.AGGREGATION_TEMPORALITY_CUMULATIVE).addDataPoints(histogramDataPoint));
            return metricBuilder.build();
        }
        return metricBuilder.setHistogram(Histogram.newBuilder().setAggregationTemporality(AggregationTemporality.AGGREGATION_TEMPORALITY_CUMULATIVE).addDataPoints(histogramDataPoint)).build();
    }

    Metric writeFunctionTimer(FunctionTimer functionTimer) {
        return this.getMetricBuilder(functionTimer.getId()).setHistogram(Histogram.newBuilder().addDataPoints(HistogramDataPoint.newBuilder().addAllAttributes(this.getTagsForId(functionTimer.getId())).setStartTimeUnixNano(((StartTimeAwareMeter)functionTimer).getStartTimeNanos()).setTimeUnixNano(TimeUnit.MILLISECONDS.toNanos(this.clock.wallTime())).setSum(functionTimer.totalTime(this.getBaseTimeUnit())).setCount((long)functionTimer.count()))).build();
    }

    private Metric.Builder getMetricBuilder(Meter.Id id) {
        Metric.Builder builder = Metric.newBuilder().setName(this.getConventionName(id));
        if (id.getBaseUnit() != null) {
            builder.setUnit(id.getBaseUnit());
        }
        if (id.getDescription() != null) {
            builder.setDescription(id.getDescription());
        }
        return builder;
    }

    private Iterable<? extends KeyValue> getTagsForId(Meter.Id id) {
        return id.getTags().stream().map(tag -> OtlpMeterRegistry.createKeyValue(tag.getKey(), tag.getValue())).collect(Collectors.toList());
    }

    static KeyValue createKeyValue(String key, String value) {
        return KeyValue.newBuilder().setKey(key).setValue(AnyValue.newBuilder().setStringValue(value)).build();
    }

    Iterable<KeyValue> getResourceAttributes() {
        boolean serviceNameProvided = false;
        ArrayList<KeyValue> attributes = new ArrayList<KeyValue>();
        attributes.add(OtlpMeterRegistry.createKeyValue("telemetry.sdk.name", "io.micrometer"));
        attributes.add(OtlpMeterRegistry.createKeyValue("telemetry.sdk.language", "java"));
        String micrometerCoreVersion = MeterRegistry.class.getPackage().getImplementationVersion();
        if (micrometerCoreVersion != null) {
            attributes.add(OtlpMeterRegistry.createKeyValue("telemetry.sdk.version", micrometerCoreVersion));
        }
        for (Map.Entry<String, String> keyValue : this.config.resourceAttributes().entrySet()) {
            if ("service.name".equals(keyValue.getKey())) {
                serviceNameProvided = true;
            }
            attributes.add(OtlpMeterRegistry.createKeyValue(keyValue.getKey(), keyValue.getValue()));
        }
        if (!serviceNameProvided) {
            attributes.add(OtlpMeterRegistry.createKeyValue("service.name", "unknown_service"));
        }
        return attributes;
    }
}

