/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.registry.otlp;

import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.cumulative.CumulativeDistributionSummary;
import io.micrometer.core.instrument.distribution.CountAtBucket;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.Histogram;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.TimeWindowFixedBoundaryHistogram;
import io.micrometer.registry.otlp.StartTimeAwareMeter;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

class OtlpDistributionSummary
extends CumulativeDistributionSummary
implements StartTimeAwareMeter {
    private static final CountAtBucket[] EMPTY_HISTOGRAM = new CountAtBucket[0];
    private final long startTimeNanos;
    @Nullable
    private final Histogram monotonicBucketCountHistogram;

    OtlpDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double scale, boolean supportsAggregablePercentiles) {
        super(id, clock, DistributionStatisticConfig.builder().percentilesHistogram(Boolean.valueOf(false)).serviceLevelObjectives(new double[0]).build().merge(distributionStatisticConfig), scale, false);
        this.startTimeNanos = TimeUnit.MILLISECONDS.toNanos(clock.wallTime());
        this.monotonicBucketCountHistogram = distributionStatisticConfig.isPublishingHistogram() ? new TimeWindowFixedBoundaryHistogram(clock, DistributionStatisticConfig.builder().expiry(Duration.ofDays(1825L)).bufferLength(Integer.valueOf(1)).build().merge(distributionStatisticConfig), true, false) : null;
    }

    protected void recordNonNegative(double amount) {
        super.recordNonNegative(amount);
        if (this.monotonicBucketCountHistogram != null) {
            this.monotonicBucketCountHistogram.recordDouble(amount);
        }
    }

    public HistogramSnapshot takeSnapshot() {
        HistogramSnapshot snapshot = super.takeSnapshot();
        if (this.monotonicBucketCountHistogram == null) {
            return snapshot;
        }
        return new HistogramSnapshot(snapshot.count(), snapshot.total(), snapshot.max(), snapshot.percentileValues(), this.histogramCounts(), (arg_0, arg_1) -> ((HistogramSnapshot)snapshot).outputSummary(arg_0, arg_1));
    }

    private CountAtBucket[] histogramCounts() {
        return this.monotonicBucketCountHistogram == null ? EMPTY_HISTOGRAM : this.monotonicBucketCountHistogram.takeSnapshot(0L, 0.0, 0.0).histogramCounts();
    }

    @Override
    public long getStartTimeNanos() {
        return this.startTimeNanos;
    }
}

