/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.registry.otlp;

import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.registry.otlp.OtlpMetricsSender;

public class OtlpHttpMetricsSender
implements OtlpMetricsSender {
    private final HttpSender httpSender;
    private final String userAgentHeader;

    public OtlpHttpMetricsSender(HttpSender httpSender) {
        this.httpSender = httpSender;
        this.userAgentHeader = this.getUserAgentHeader();
    }

    @Override
    public void send(OtlpMetricsSender.Request request) throws Exception {
        HttpSender.Response response;
        if (request.getAddress() == null) {
            throw new IllegalArgumentException("Address cannot be null");
        }
        HttpSender.Request.Builder httpRequest = this.httpSender.post(request.getAddress()).withHeader("User-Agent", this.userAgentHeader).withContent("application/x-protobuf", request.getMetricsData());
        request.getHeaders().forEach((arg_0, arg_1) -> ((HttpSender.Request.Builder)httpRequest).withHeader(arg_0, arg_1));
        try {
            response = httpRequest.send();
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
        if (!response.isSuccessful()) {
            throw new OtlpHttpMetricsSendUnsuccessfulException(String.format("Server responded with HTTP status code %d and body %s", response.code(), response.body()));
        }
    }

    private String getUserAgentHeader() {
        String userAgent = "Micrometer-OTLP-Exporter-Java";
        String version = this.getClass().getPackage().getImplementationVersion();
        if (version != null) {
            userAgent = userAgent + "/" + version;
        }
        return userAgent;
    }

    private static class OtlpHttpMetricsSendUnsuccessfulException
    extends RuntimeException {
        private OtlpHttpMetricsSendUnsuccessfulException(String message) {
            super(message);
        }
    }
}

