/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheus;

import io.micrometer.core.instrument.AbstractDistributionSummary;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.CountAtValue;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.histogram.TimeWindowHistogram;
import io.micrometer.core.instrument.util.MeterEquivalence;
import io.micrometer.core.instrument.util.TimeDecayingMax;
import java.time.Duration;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;

public class PrometheusDistributionSummary
extends AbstractDistributionSummary {
    private LongAdder count = new LongAdder();
    private DoubleAdder amount = new DoubleAdder();
    private TimeDecayingMax max;
    private final TimeWindowHistogram percentilesHistogram;

    PrometheusDistributionSummary(Meter.Id id, Clock clock, HistogramConfig histogramConfig) {
        super(id, clock, histogramConfig);
        this.max = new TimeDecayingMax(clock, histogramConfig);
        this.percentilesHistogram = new TimeWindowHistogram(clock, HistogramConfig.builder().histogramExpiry(Duration.ofDays(1825L)).histogramBufferLength(Integer.valueOf(1)).build().merge(histogramConfig));
    }

    protected void recordNonNegative(double amount) {
        this.count.increment();
        this.amount.add(amount);
        this.max.record(amount);
        this.percentilesHistogram.recordDouble(amount);
    }

    public long count() {
        return this.count.longValue();
    }

    public double totalAmount() {
        return this.amount.doubleValue();
    }

    public double max() {
        return this.max.poll();
    }

    public boolean equals(Object o) {
        return MeterEquivalence.equals((Meter)this, (Object)o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode((Meter)this);
    }

    public CountAtValue[] percentileBuckets() {
        return this.percentilesHistogram.takeSnapshot(0L, 0.0, 0.0, true).histogramCounts();
    }
}

