/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheus;

import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.CountAtValue;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.histogram.TimeWindowLatencyHistogram;
import io.micrometer.core.instrument.histogram.pause.PauseDetector;
import io.micrometer.core.instrument.util.TimeDecayingMax;
import io.micrometer.core.instrument.util.TimeUtils;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public class PrometheusTimer
extends AbstractTimer
implements Timer {
    private final LongAdder count = new LongAdder();
    private final LongAdder totalTime = new LongAdder();
    private final TimeDecayingMax max;
    private final TimeWindowLatencyHistogram percentilesHistogram;

    PrometheusTimer(Meter.Id id, Clock clock, HistogramConfig histogramConfig, PauseDetector pauseDetector) {
        super(id, clock, histogramConfig, pauseDetector, TimeUnit.SECONDS);
        this.max = new TimeDecayingMax(clock, histogramConfig);
        this.percentilesHistogram = new TimeWindowLatencyHistogram(clock, HistogramConfig.builder().histogramExpiry(Duration.ofDays(1825L)).histogramBufferLength(Integer.valueOf(1)).build().merge(histogramConfig), pauseDetector);
    }

    protected void recordNonNegative(long amount, TimeUnit unit) {
        this.count.increment();
        long nanoAmount = TimeUnit.NANOSECONDS.convert(amount, unit);
        this.totalTime.add(nanoAmount);
        this.percentilesHistogram.recordLong(nanoAmount);
        this.max.record((double)nanoAmount, TimeUnit.NANOSECONDS);
    }

    public long count() {
        return this.count.longValue();
    }

    public double totalTime(TimeUnit unit) {
        return TimeUtils.nanosToUnit((double)this.totalTime.doubleValue(), (TimeUnit)unit);
    }

    public double max(TimeUnit unit) {
        return this.max.poll(unit);
    }

    public CountAtValue[] percentileBuckets() {
        return this.percentilesHistogram.takeSnapshot(0L, 0.0, 0.0, true).histogramCounts();
    }
}

